/*
 * Decompiled with CFR 0.152.
 */
package com.armatyrich.taczxgunlightsaddon.server;

import com.armatyrich.taczxgunlightsaddon.server.ServerMuzzleFlashManager;
import com.tacz.guns.api.TimelessAPI;
import com.tacz.guns.api.event.common.GunFireEvent;
import com.tacz.guns.api.item.IGun;
import com.tacz.guns.resource.index.CommonGunIndex;
import com.tacz.guns.resource.modifier.AttachmentCacheProperty;
import com.tacz.guns.resource.modifier.custom.SilenceModifier;
import com.tacz.guns.resource.pojo.data.gun.GunData;
import it.unimi.dsi.fastutil.Pair;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class GunFireEventHandler {
    @SubscribeEvent
    public static void onGunFire(GunFireEvent event) {
        Level level = event.getShooter().m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        LivingEntity shooter = event.getShooter();
        ItemStack gun = event.getGunItemStack();
        if (gun.m_41784_().m_128445_("Jammed") != 0) {
            return;
        }
        int lightLevel = GunFireEventHandler.isSilenced(gun) ? 6 : 15;
        Vec3 muzzleVec = shooter.m_146892_().m_82549_(shooter.m_20154_().m_82490_(1.0));
        BlockPos muzzlePos = BlockPos.m_274446_((Position)muzzleVec);
        ServerMuzzleFlashManager.placeFlash(serverLevel, muzzlePos, lightLevel);
    }

    private static boolean isSilenced(ItemStack gun) {
        Boolean b;
        Pair pair;
        Object object;
        Item item;
        if (gun.m_41619_() || !((item = gun.m_41720_()) instanceof IGun)) {
            return false;
        }
        IGun igun = (IGun)item;
        ResourceLocation gunId = igun.getGunId(gun);
        Optional gunIndexOpt = TimelessAPI.getCommonGunIndex((ResourceLocation)gunId);
        if (gunIndexOpt.isEmpty()) {
            return false;
        }
        GunData gunData = ((CommonGunIndex)gunIndexOpt.get()).getGunData();
        AttachmentCacheProperty cache = new AttachmentCacheProperty();
        cache.eval(gun, gunData);
        Object silenceData = cache.getCache(SilenceModifier.ID);
        return silenceData instanceof Pair && (object = (pair = (Pair)silenceData).right()) instanceof Boolean && (b = (Boolean)object) != false;
    }
}

