/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.injection;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.tlauncher.injection.Injection;
import org.tlauncher.injection.InjectionHelper;

public class InjectionManager {
    private static final List<Injection> EMPTY_INJECTION_LIST = new ArrayList<Injection>();
    private final Map<String, List<Injection>> injectionMap = new HashMap<String, List<Injection>>();
    private final Map<String, InjectionHelper> injectionHelperMap = new HashMap<String, InjectionHelper>();

    public void addInjection(String targetClassName, Injection injection) {
        this.injectionMap.putIfAbsent(targetClassName, new ArrayList());
        this.injectionMap.get(targetClassName).add(injection);
        this.injectionHelperMap.putIfAbsent(targetClassName, new InjectionHelper());
    }

    public InjectionHelper getHelper(String targetClassName) {
        return this.injectionHelperMap.get(targetClassName);
    }

    public List<Injection> getInjections(String targetClassName) {
        return this.injectionMap.getOrDefault(targetClassName, EMPTY_INJECTION_LIST);
    }
}

