/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.minecraft;

import java.lang.reflect.Method;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceLocation;
import org.tlauncher.injection.mapping.MappingManager;
import org.tlauncher.injection.mapping.ObfClass;
import org.tlauncher.minecraft.GameTextureManager;
import org.tlauncher.minecraft.Resource;
import org.tlauncher.renderer.texture.LightTexture;
import org.tlauncher.util.TLModCfg;
import org.tlauncher.util.TypeLocator;

public class GameTextureManagerImpl
implements GameTextureManager,
TypeLocator {
    private final Supplier<Minecraft> getMinecraft;
    private final Method loadTextureMethod;
    private final Method deleteTextureMethod;

    public GameTextureManagerImpl(Supplier<Minecraft> getMinecraft) {
        String loadTextureMethodName;
        this.getMinecraft = getMinecraft;
        Class<TextureManager> textureManagerClass = TextureManager.class;
        ObfClass classMappings = MappingManager.instance().getMappings().getClass("TextureManager");
        String string = TLModCfg.isForgeDetected() ? "m_118515_" : (loadTextureMethodName = TLModCfg.isFabricDetected() ? "method_24303" : classMappings.getMethod("loadTexture").getObfName());
        String safeCloseMethodName = TLModCfg.isForgeDetected() ? "m_118508_" : (TLModCfg.isFabricDetected() ? "method_30299" : classMappings.getMethod("safeClose").getObfName());
        this.loadTextureMethod = this.findMethod(textureManagerClass, new TypeLocator.MethodData(true, loadTextureMethodName, ResourceLocation.class, AbstractTexture.class));
        this.deleteTextureMethod = this.findMethod(textureManagerClass, new TypeLocator.MethodData(true, safeCloseMethodName, ResourceLocation.class, AbstractTexture.class));
        this.loadTextureMethod.setAccessible(true);
        this.deleteTextureMethod.setAccessible(true);
    }

    @Override
    public void loadTexture(Resource resource, LightTexture lightTexture) {
        this.getMinecraft.get().m_91097_().m_118495_((ResourceLocation)resource, (AbstractTexture)lightTexture);
    }

    @Override
    public void deleteTexture(Resource resource) {
        AbstractTexture texture = this.getMinecraft.get().m_91097_().m_118506_((ResourceLocation)resource);
        this.deleteTextureMethod.invoke((Object)this.getMinecraft.get().m_91097_(), new Object[]{resource, texture});
    }

    @Override
    public LightTexture getTexture(Resource resource) {
        return (LightTexture)this.getMinecraft.get().m_91097_().m_118506_((ResourceLocation)resource);
    }
}

