/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.api.applier;

import com.ferreusveritas.dynamictrees.deserialisation.result.Result;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Optional;

public final class PropertyApplierResult {
    private String errorMessage;
    private final List<String> warnings;

    private PropertyApplierResult(String errorMessage) {
        this(errorMessage, Lists.newLinkedList());
    }

    private PropertyApplierResult(String errorMessage, List<String> warnings) {
        this.errorMessage = errorMessage;
        this.warnings = warnings;
    }

    public boolean wasSuccessful() {
        return this.errorMessage == null;
    }

    public Optional<String> getError() {
        return Optional.ofNullable(this.errorMessage);
    }

    public PropertyApplierResult addErrorPrefix(String prefix) {
        this.errorMessage = prefix + this.errorMessage;
        return this;
    }

    public List<String> getWarnings() {
        return this.warnings;
    }

    public void addWarnings(List<String> warning) {
        this.warnings.addAll(warning);
    }

    public PropertyApplierResult addWarningsPrefix(String prefix) {
        this.warnings.replaceAll(warning -> {
            warning = prefix + (String)warning;
            return warning;
        });
        return this;
    }

    public static PropertyApplierResult success() {
        return new PropertyApplierResult(null);
    }

    public static PropertyApplierResult success(List<String> warnings) {
        return new PropertyApplierResult(null, warnings);
    }

    public static PropertyApplierResult failure(String errorMessage) {
        return new PropertyApplierResult(errorMessage);
    }

    public static PropertyApplierResult failure(String errorMessage, List<String> warnings) {
        return new PropertyApplierResult(errorMessage, warnings);
    }

    public static PropertyApplierResult from(Result<?, ?> result) {
        return result.success() ? PropertyApplierResult.success(result.getWarnings()) : PropertyApplierResult.failure(result.getError(), result.getWarnings());
    }
}

