/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.compat;

import com.ferreusveritas.dynamictrees.DynamicTrees;
import com.ferreusveritas.dynamictrees.init.DTRegistries;
import com.ferreusveritas.dynamictrees.item.DendroPotion;
import java.util.ArrayList;
import java.util.Collections;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.recipe.vanilla.IJeiBrewingRecipe;
import mezz.jei.api.recipe.vanilla.IVanillaRecipeFactory;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

@JeiPlugin
public final class DTJeiPlugin
implements IModPlugin {
    public ResourceLocation getPluginUid() {
        return DynamicTrees.location("dynamictrees");
    }

    public void registerItemSubtypes(ISubtypeRegistration registration) {
        registration.useNbtForSubtypes(new Item[]{DTRegistries.DENDRO_POTION.get()});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        IVanillaRecipeFactory factory = registration.getVanillaRecipeFactory();
        ArrayList brewingRecipes = new ArrayList();
        DendroPotion.brewingRecipes.forEach(recipe -> brewingRecipes.add(DTJeiPlugin.makeJeiBrewingRecipe(factory, recipe.input(), recipe.ingredient(), recipe.output())));
        registration.addRecipes(RecipeTypes.BREWING, brewingRecipes);
    }

    private static IJeiBrewingRecipe makeJeiBrewingRecipe(IVanillaRecipeFactory factory, ItemStack inputStack, ItemStack ingredientStack, ItemStack output) {
        return factory.createBrewingRecipe(Collections.singletonList(ingredientStack), inputStack, output);
    }
}

