/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.compat.waila;

import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.TreeRegistry;
import com.ferreusveritas.dynamictrees.api.network.MapSignal;
import com.ferreusveritas.dynamictrees.block.branch.BranchBlock;
import com.ferreusveritas.dynamictrees.block.branch.TrunkShellBlock;
import com.ferreusveritas.dynamictrees.compat.waila.WailaOther;
import com.ferreusveritas.dynamictrees.systems.fruit.Fruit;
import com.ferreusveritas.dynamictrees.systems.nodemapper.NetVolumeNode;
import com.ferreusveritas.dynamictrees.systems.pod.Pod;
import com.ferreusveritas.dynamictrees.tree.species.Species;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.ui.IElement;
import snownee.jade.impl.ui.ElementHelper;

public class WailaBranchHandler
implements IBlockComponentProvider {
    public static final ResourceLocation ID = new ResourceLocation("dynamictrees", "branch");
    private BlockPos lastPos = BlockPos.f_121853_;
    private Species lastSpecies = Species.NULL_SPECIES;
    private NetVolumeNode.Volume lastVolume = new NetVolumeNode.Volume();

    public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
        if (WailaOther.invalid) {
            this.lastPos = BlockPos.f_121853_;
            this.lastSpecies = Species.NULL_SPECIES;
            this.lastVolume = new NetVolumeNode.Volume();
            WailaOther.invalid = false;
        }
        CompoundTag nbtData = accessor.getServerData();
        BlockPos pos = accessor.getPosition();
        Species species = Species.NULL_SPECIES;
        if (nbtData.m_128441_("species")) {
            species = TreeRegistry.findSpecies(new ResourceLocation(nbtData.m_128461_("species")));
        }
        if (species == Species.NULL_SPECIES && this.lastPos.equals((Object)pos)) {
            species = this.lastSpecies;
        }
        if (species == Species.NULL_SPECIES) {
            species = this.getWailaSpecies(accessor.getLevel(), pos);
        }
        if (!species.useDefaultWailaBody()) {
            return;
        }
        if (!this.lastPos.equals((Object)pos)) {
            this.lastVolume = this.getTreeVolume(accessor.getLevel(), pos, species);
        }
        this.lastSpecies = species;
        this.lastPos = pos;
        if (species != Species.NULL_SPECIES) {
            if (species.showSpeciesOnWaila()) {
                tooltip.add((Component)Component.m_237110_((String)"tooltip.dynamictrees.species", (Object[])new Object[]{species.getTextComponent()}));
            }
            if (Minecraft.m_91087_().f_91066_.f_92125_) {
                tooltip.add((Component)Component.m_237113_((String)(String.valueOf(ChatFormatting.DARK_GRAY) + species.getRegistryName().toString())));
            }
            ItemStack seedStack = species.getSeedStack(1);
            LinkedList<IElement> elements = new LinkedList<IElement>();
            elements.add(WailaBranchHandler.getElement(seedStack));
            if (species.hasFruits()) {
                for (Fruit fruit : species.getFruits()) {
                    ItemStack fruitStack = fruit.getItemStack();
                    if (fruitStack.m_41720_() == seedStack.m_41720_()) continue;
                    elements.add(WailaBranchHandler.getElement(fruitStack));
                }
            }
            if (species.hasPods()) {
                for (Pod pod : species.getPods()) {
                    ItemStack podStack = pod.getItemStack();
                    if (podStack.m_41720_() == seedStack.m_41720_()) continue;
                    elements.add(WailaBranchHandler.getElement(podStack));
                }
            }
            Map handEnchantments = EnchantmentHelper.m_44831_((ItemStack)accessor.getPlayer().m_21205_());
            int silkTouch = Optional.ofNullable((Integer)handEnchantments.get(Enchantments.f_44985_)).orElse(0);
            int fortune = Optional.ofNullable((Integer)handEnchantments.get(Enchantments.f_44987_)).orElse(0);
            if (this.lastVolume.getVolume() > 0.0f) {
                ItemStack stickStack;
                Species.LogsAndSticks las = species.getLogsAndSticks(this.lastVolume, silkTouch > 0, fortune);
                List<ItemStack> logStacks = las.logs;
                if (!logStacks.isEmpty()) {
                    for (ItemStack logStack : logStacks) {
                        elements.add(WailaBranchHandler.getElement(logStack));
                    }
                }
                if (las.sticks > 0 && !(stickStack = species.getFamily().getStick(las.sticks)).m_41619_()) {
                    elements.add(WailaBranchHandler.getElement(stickStack));
                }
            }
            tooltip.add((IElement)elements.remove(0));
            elements.forEach(arg_0 -> ((ITooltip)tooltip).append(arg_0));
            tooltip.add(ElementHelper.INSTANCE.spacer(0, 2));
        }
    }

    private NetVolumeNode.Volume getTreeVolume(Level level, BlockPos pos, Species species) {
        TrunkShellBlock.ShellMuse muse;
        BlockState state = level.m_8055_(pos);
        Block block = state.m_60734_();
        if (block instanceof TrunkShellBlock && (muse = ((TrunkShellBlock)block).getMuse((BlockGetter)level, pos)) != null) {
            state = muse.state;
            block = state.m_60734_();
            pos = muse.pos;
        }
        if (block instanceof BranchBlock) {
            BranchBlock branch = (BranchBlock)block;
            NetVolumeNode volumeSum = new NetVolumeNode();
            branch.analyse(state, (LevelAccessor)level, pos, null, new MapSignal(volumeSum));
            NetVolumeNode.Volume volume = volumeSum.getVolume();
            species.processVolume(volume);
            return volume;
        }
        return new NetVolumeNode.Volume();
    }

    private Species getWailaSpecies(Level level, BlockPos pos) {
        return TreeHelper.getBestGuessSpecies(level, pos);
    }

    private static IElement getElement(ItemStack stack) {
        if (!stack.m_41619_()) {
            return ElementHelper.INSTANCE.item(stack);
        }
        return ElementHelper.INSTANCE.spacer(0, 0);
    }

    public ResourceLocation getUid() {
        return ID;
    }
}

