/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.deserialisation;

import com.ferreusveritas.dynamictrees.deserialisation.DeserialisationException;
import com.ferreusveritas.dynamictrees.deserialisation.JsonDeserialiser;
import com.ferreusveritas.dynamictrees.deserialisation.JsonDeserialisers;
import com.ferreusveritas.dynamictrees.deserialisation.JsonPropertyApplierLists;
import com.ferreusveritas.dynamictrees.util.IgnoreThrowable;
import com.ferreusveritas.dynamictrees.util.JsonMapWrapper;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.MapColor;
import net.minecraftforge.fml.ModList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class JsonHelper {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();

    public static Gson getGson() {
        return GSON;
    }

    @Nullable
    public static JsonElement load(@Nullable File file) {
        if (file != null && file.exists() && file.isFile() && file.canRead()) {
            String fileName = file.getAbsolutePath();
            try {
                JsonParser parser = new JsonParser();
                return parser.parse((Reader)new FileReader(file));
            }
            catch (Exception e) {
                LOGGER.fatal("Can't open " + fileName + ": " + e.getMessage());
            }
        }
        return null;
    }

    public static boolean isComment(JsonElement jsonElement) {
        return JsonDeserialisers.STRING.deserialise(jsonElement).map(string -> JsonHelper.isComment(string)).orElse(false);
    }

    public static boolean isComment(String key) {
        return key.startsWith("_");
    }

    public static <T> T getOrDefault(JsonObject jsonObject, String elementName, Class<T> type, T defaultValue) {
        JsonElement element = jsonObject.get(elementName);
        if (element == null) {
            return defaultValue;
        }
        return (T)JsonDeserialisers.get(type).deserialise(element).orElse(defaultValue);
    }

    public static <T> T getOrDefault(JsonObject jsonObject, String elementName, Class<T> type, T defaultValue, Consumer<String> errorConsumer, Consumer<String> warningConsumer) {
        JsonElement element = jsonObject.get(elementName);
        if (element == null) {
            return defaultValue;
        }
        return (T)JsonDeserialisers.get(type).deserialise(element).orElse(defaultValue, errorConsumer, warningConsumer);
    }

    public static <T> Optional<T> getAsOptional(JsonObject object, String key, JsonDeserialiser<T> deserialiser) throws DeserialisationException {
        JsonElement element = object.get(key);
        return element == null ? Optional.empty() : (Optional)deserialiser.deserialise(element).map(Optional::ofNullable).orElseThrow();
    }

    public static BlockBehaviour.Properties getBlockProperties(JsonObject jsonObject, MapColor defaultMapColor, Function<MapColor, BlockBehaviour.Properties> defaultPropertiesGetter, Consumer<String> errorConsumer, Consumer<String> warningConsumer) {
        BlockBehaviour.Properties properties = defaultPropertiesGetter.apply(JsonHelper.getOrDefault(jsonObject, "map_color", MapColor.class, defaultMapColor));
        JsonPropertyApplierLists.PROPERTIES.applyAll(new JsonMapWrapper(jsonObject), properties).forEachErrorWarning(errorConsumer, warningConsumer);
        return properties;
    }

    public static <T extends Throwable> void throwIfNotJsonObject(JsonElement json, Supplier<T> throwableSupplier) throws T {
        if (!json.isJsonObject()) {
            throw (Throwable)throwableSupplier.get();
        }
    }

    public static void throwIfShouldNotLoad(JsonObject json) throws IgnoreThrowable {
        String key = "only_if_loaded";
        if (!json.has("only_if_loaded")) {
            return;
        }
        JsonElement element = json.get("only_if_loaded");
        AtomicBoolean continueLoading = new AtomicBoolean(true);
        if (element.isJsonArray()) {
            element.getAsJsonArray().forEach(element1 -> {
                if (!JsonHelper.isModLoaded(element1)) {
                    continueLoading.set(false);
                }
            });
        } else if (element.isJsonPrimitive()) {
            continueLoading.set(JsonHelper.isModLoaded(element));
        }
        if (!continueLoading.get()) {
            throw IgnoreThrowable.INSTANCE;
        }
    }

    private static boolean isModLoaded(JsonElement element) {
        return JsonDeserialisers.STRING.deserialise(element).map(modId -> {
            if (modId.charAt(0) == '!') {
                return !ModList.get().isLoaded(modId.substring(1));
            }
            return ModList.get().isLoaded(modId);
        }).orElse(true);
    }
}

