/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.entity.animation;

import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.block.branch.BranchBlock;
import com.ferreusveritas.dynamictrees.client.SoundInstanceHandler;
import com.ferreusveritas.dynamictrees.data.DTEntityTypeTags;
import com.ferreusveritas.dynamictrees.entity.FallingTreeEntity;
import com.ferreusveritas.dynamictrees.entity.animation.AnimationConstants;
import com.ferreusveritas.dynamictrees.entity.animation.AnimationHandler;
import com.ferreusveritas.dynamictrees.entity.animation.DataAnimationHandler;
import com.ferreusveritas.dynamictrees.init.DTConfigs;
import com.ferreusveritas.dynamictrees.tree.species.Species;
import com.ferreusveritas.dynamictrees.util.BranchDestructionData;
import com.ferreusveritas.dynamictrees.util.MathHelper;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class FalloverAnimationHandler
implements AnimationHandler {
    public static int TICKS_BEFORE_CHECKING_COLLISION = 10;

    @Override
    public String getName() {
        return "fallover";
    }

    HandlerData getData(FallingTreeEntity entity) {
        return entity.dataAnimationHandler != null ? (HandlerData)entity.dataAnimationHandler : new HandlerData();
    }

    protected void playStartSound(FallingTreeEntity entity) {
        if (!this.getData((FallingTreeEntity)entity).startSoundPlayed && entity.m_9236_().m_5776_()) {
            Species species = entity.getSpecies();
            SoundEvent sound = species.getFallingTreeStartSound(entity.getVolume(), entity.hasLeaves());
            SoundInstanceHandler.playSoundInstance(sound, species.getFallingTreePitch(entity.getVolume()), entity.m_20182_(), entity);
        }
    }

    protected void playEndSound(FallingTreeEntity entity) {
        if (!this.getData((FallingTreeEntity)entity).endSoundPlayed) {
            if (entity.m_9236_().f_46443_) {
                SoundInstanceHandler.stopSoundInstance(entity);
            } else {
                Species species = entity.getSpecies();
                SoundEvent sound = species.getFallingTreeEndSound(entity.getVolume(), entity.hasLeaves());
                entity.m_5496_(sound, 1.5f, species.getFallingTreePitch(entity.getVolume()));
                this.getData((FallingTreeEntity)entity).endSoundPlayed = true;
            }
        }
    }

    protected void playFallThroughWaterSound(FallingTreeEntity entity) {
        if (!this.getData((FallingTreeEntity)entity).fallThroughWaterSoundPlayed && !entity.m_9236_().m_5776_()) {
            entity.m_5496_(entity.getSpecies().getFallingTreeHitWaterSound(entity.getVolume(), entity.hasLeaves()), 2.0f, 1.0f);
            this.getData((FallingTreeEntity)entity).fallThroughWaterSoundPlayed = true;
        }
    }

    private Vec3 rotateAroundAxis(Vec3 in, Vec3 axis, double theta) {
        double x = in.f_82479_;
        double y = in.f_82480_;
        double z = in.f_82481_;
        double u = axis.f_82479_;
        double v = axis.f_82480_;
        double w = axis.f_82481_;
        double v1 = u * x + v * y + w * z;
        double xPrime = u * v1 * (1.0 - Math.cos(theta)) + x * Math.cos(theta) + (-w * y + v * z) * Math.sin(theta);
        double yPrime = v * v1 * (1.0 - Math.cos(theta)) + y * Math.cos(theta) + (w * x - u * z) * Math.sin(theta);
        double zPrime = w * v1 * (1.0 - Math.cos(theta)) + z * Math.cos(theta) + (-v * x + u * y) * Math.sin(theta);
        return new Vec3(xPrime, yPrime, zPrime);
    }

    protected void flingLeavesParticles(FallingTreeEntity entity, float fallSpeed) {
        int bounces = this.getData((FallingTreeEntity)entity).bounces;
        if (bounces > 1) {
            return;
        }
        int maxParticleBlocks = (Integer)DTConfigs.MAX_FALLING_TREE_LEAVES_PARTICLES.get();
        if (maxParticleBlocks == 0) {
            return;
        }
        BranchDestructionData data = entity.getDestroyData();
        Direction.Axis toolAxis = data.toolDir.m_122434_();
        if (toolAxis == Direction.Axis.Y) {
            return;
        }
        double limitChance = 1.0;
        if (entity.getDestroyData().getNumLeaves() > maxParticleBlocks) {
            limitChance = (double)maxParticleBlocks / (double)entity.getDestroyData().getNumLeaves();
        }
        limitChance *= Math.exp(-bounces);
        RandomSource rand = entity.m_9236_().f_46441_;
        int particleCount = bounces == 0 ? (int)(fallSpeed * 5.0f) : 1;
        Vec3 angularVel = entity.m_20156_().m_82490_((double)(fallSpeed * (float)(-data.toolDir.m_122421_().m_122540_())));
        if (toolAxis == Direction.Axis.X) {
            angularVel = new Vec3(angularVel.f_82481_, angularVel.f_82479_, angularVel.f_82480_);
        }
        for (int i = 0; i < data.getNumLeaves(); ++i) {
            BlockPos leaves = data.getLeavesRelPos(i).m_121955_((Vec3i)data.basePos);
            double r = leaves.m_123342_() - data.basePos.m_123342_();
            Vec3 velocity = angularVel.m_82490_(r);
            BlockState leavesState = entity.getDestroyData().getLeavesBlockState(i);
            this.spawnParticlesAtLeaves(entity, leaves, leavesState, velocity, rand, particleCount, limitChance);
        }
    }

    protected void spawnParticlesAtLeaves(FallingTreeEntity entity, BlockPos leavesPos, BlockState leavesState, Vec3 velocity, RandomSource rand, int particleCount, double limitChance) {
        Vec3 newPos = this.getRelativeLeavesPosition(entity, leavesPos.m_252807_());
        for (int j = 0; j < particleCount; ++j) {
            if (!(rand.m_188500_() < limitChance) || leavesState == null) continue;
            entity.m_9236_().m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, leavesState), newPos.f_82479_ + (double)rand.m_188501_(), newPos.f_82480_ + (double)rand.m_188501_(), newPos.f_82481_ + (double)rand.m_188501_(), velocity.f_82479_ + (double)rand.m_188501_(), velocity.f_82480_ + (double)rand.m_188501_(), velocity.f_82481_ + (double)rand.m_188501_());
        }
    }

    protected Vec3 getRelativeLeavesPosition(FallingTreeEntity entity, Vec3 leaves) {
        BranchDestructionData data = entity.getDestroyData();
        float angle = (data.toolDir.m_122434_() == Direction.Axis.X ? entity.m_146908_() : entity.m_146909_()) * (float)(-data.toolDir.m_122421_().m_122540_()) * 0.0174533f;
        return this.rotateAroundAxis(leaves.m_82546_(data.basePos.m_252807_()), new Vec3((double)(-data.toolDir.m_122431_()), 0.0, (double)data.toolDir.m_122429_()), angle).m_82549_(data.basePos.m_252807_()).m_82492_(0.5, 0.5, 0.5);
    }

    @Override
    public void initMotion(FallingTreeEntity entity) {
        entity.dataAnimationHandler = new HandlerData();
        FallingTreeEntity.standardDropLeavesPayLoad(entity);
        this.playStartSound(entity);
        BlockPos belowBlock = entity.getDestroyData().cutPos.m_7495_();
        if (entity.m_9236_().m_8055_(belowBlock).m_60783_((BlockGetter)entity.m_9236_(), belowBlock, Direction.UP)) {
            entity.m_6853_(true);
        }
    }

    @Override
    public void handleMotion(FallingTreeEntity entity) {
        float fallSpeed = this.getData((FallingTreeEntity)entity).fallSpeed;
        if (entity.m_20096_()) {
            float height = (float)entity.getMassCenter().f_82480_ * 2.0f;
            this.addRotation(entity, fallSpeed += (float)(0.2 / (double)height));
        }
        entity.m_20334_(entity.m_20184_().f_82479_, entity.m_20184_().f_82480_ - (double)0.03f, entity.m_20184_().f_82481_);
        entity.m_6034_(entity.m_20185_(), entity.m_20186_() + entity.m_20184_().f_82480_, entity.m_20189_());
        Level level = entity.m_9236_();
        int radius = 8;
        BlockState state = entity.getDestroyData().getBranchBlockState(0);
        if (TreeHelper.isBranch(state)) {
            radius = ((BranchBlock)state.m_60734_()).getRadius(state);
        }
        AABB fallBox = new AABB(entity.m_20185_() - (double)radius, entity.m_20186_(), entity.m_20189_() - (double)radius, entity.m_20185_() + (double)radius, entity.m_20186_() + 1.0, entity.m_20189_() + (double)radius);
        BlockPos pos = BlockPos.m_274561_((double)entity.m_20185_(), (double)entity.m_20186_(), (double)entity.m_20189_());
        BlockState collState = level.m_8055_(pos);
        VoxelShape shape = collState.m_60816_((BlockGetter)level, pos);
        AABB collBox = new AABB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        if (!shape.m_83281_()) {
            collBox = collState.m_60816_((BlockGetter)level, pos).m_83215_();
        }
        if (fallBox.m_82381_(collBox = collBox.m_82338_(pos))) {
            entity.m_20334_(entity.m_20184_().f_82479_, 0.0, entity.m_20184_().f_82481_);
            entity.m_6034_(entity.m_20185_(), collBox.f_82292_, entity.m_20189_());
            entity.f_19855_ = entity.m_20186_();
            entity.m_6853_(true);
        }
        if (entity.f_19797_ > TICKS_BEFORE_CHECKING_COLLISION && fallSpeed > 0.0f && this.testCollision(entity)) {
            this.playEndSound(entity);
            this.flingLeavesParticles(entity, fallSpeed);
            this.addRotation(entity, -fallSpeed);
            ++this.getData((FallingTreeEntity)entity).bounces;
            entity.landed = Math.abs(fallSpeed *= -0.25f) < 0.02f;
        }
        level = entity.m_9236_();
        if (((Boolean)DTConfigs.ENABLE_FALLING_TREE_DAMAGE.get()).booleanValue() && !level.f_46443_) {
            List<LivingEntity> elist = this.testEntityCollision(entity);
            for (LivingEntity living : elist) {
                if (this.getData((FallingTreeEntity)entity).entitiesHit.contains(living) || living.m_6095_().m_204039_(DTEntityTypeTags.FALLING_TREE_DAMAGE_IMMUNE)) continue;
                this.getData((FallingTreeEntity)entity).entitiesHit.add(living);
                float damage = entity.getDestroyData().woodVolume.getVolume() * Math.abs(fallSpeed) * 3.0f;
                if (this.getData((FallingTreeEntity)entity).bounces != 0 || !(damage > 2.0f)) continue;
                living.m_20334_(living.m_20184_().f_82479_ + (double)(level.f_46441_.m_188501_() * (float)entity.getDestroyData().toolDir.m_122424_().m_122429_() * damage * 0.2f), living.m_20184_().f_82480_ + (double)(level.f_46441_.m_188501_() * fallSpeed * 0.25f), living.m_20184_().f_82481_ + (double)(level.f_46441_.m_188501_() * (float)entity.getDestroyData().toolDir.m_122424_().m_122431_() * damage * 0.2f));
                living.m_20334_(living.m_20184_().f_82479_ + ((double)level.f_46441_.m_188501_() - 0.5), living.m_20184_().f_82480_, living.m_20184_().f_82481_ + ((double)level.f_46441_.m_188501_() - 0.5));
                damage = (float)((double)damage * (Double)DTConfigs.FALLING_TREE_DAMAGE_MULTIPLIER.get());
                living.m_6469_(AnimationConstants.treeDamage(level.m_9598_()), damage);
            }
        }
        this.getData((FallingTreeEntity)entity).fallSpeed = fallSpeed;
    }

    private boolean testCollision(FallingTreeEntity entity) {
        Direction toolDir = entity.getDestroyData().toolDir;
        float actingAngle = toolDir.m_122434_() == Direction.Axis.X ? entity.m_146908_() : entity.m_146909_();
        int offsetX = toolDir.m_122429_();
        int offsetZ = toolDir.m_122431_();
        float h = Mth.m_14031_((float)((float)Math.toRadians(actingAngle))) * (float)(offsetX | offsetZ);
        float v = Mth.m_14089_((float)((float)Math.toRadians(actingAngle)));
        float xbase = (float)(entity.m_20185_() + (double)((float)offsetX * (-0.5f + v * 0.5f + h * 0.5f)));
        float ybase = (float)(entity.m_20186_() - (double)(h * 0.5f) + (double)(v * 0.5f));
        float zbase = (float)(entity.m_20189_() + (double)((float)offsetZ * (-0.5f + v * 0.5f + h * 0.5f)));
        int trunkHeight = entity.getDestroyData().trunkHeight;
        float maxRadius = (float)entity.getDestroyData().getBranchRadius(0) / 16.0f;
        trunkHeight = Math.min(trunkHeight, 24);
        for (int segment = 0; segment < trunkHeight; ++segment) {
            float segX = xbase + h * (float)segment * (float)offsetX;
            float segY = ybase + v * (float)segment;
            float segZ = zbase + h * (float)segment * (float)offsetZ;
            float tex = 0.0625f;
            float half = Mth.m_14036_((float)(tex * (float)(segment + 1) * 2.0f), (float)tex, (float)maxRadius);
            AABB testBB = new AABB((double)(segX - half), (double)(segY - half), (double)(segZ - half), (double)(segX + half), (double)(segY + half), (double)(segZ + half));
            if (entity.m_9236_().m_46855_(testBB)) {
                this.playFallThroughWaterSound(entity);
            }
            if (entity.m_9236_().m_45756_((Entity)entity, testBB)) continue;
            return true;
        }
        return false;
    }

    private void addRotation(FallingTreeEntity entity, float delta) {
        Direction toolDir = entity.getDestroyData().toolDir;
        switch (toolDir) {
            case NORTH: {
                entity.m_146926_(entity.m_146909_() + delta);
                break;
            }
            case SOUTH: {
                entity.m_146926_(entity.m_146909_() - delta);
                break;
            }
            case WEST: {
                entity.m_146922_(entity.m_146908_() + delta);
                break;
            }
            case EAST: {
                entity.m_146922_(entity.m_146908_() - delta);
                break;
            }
        }
        entity.m_146926_(Mth.m_14177_((float)entity.m_146909_()));
        entity.m_146922_(Mth.m_14177_((float)entity.m_146908_()));
    }

    public List<LivingEntity> testEntityCollision(FallingTreeEntity entity) {
        Level level = entity.m_9236_();
        Direction toolDir = entity.getDestroyData().toolDir;
        float actingAngle = toolDir.m_122434_() == Direction.Axis.X ? entity.m_146908_() : entity.m_146909_();
        int offsetX = toolDir.m_122429_();
        int offsetZ = toolDir.m_122431_();
        float h = Mth.m_14031_((float)((float)Math.toRadians(actingAngle))) * (float)(offsetX | offsetZ);
        float v = Mth.m_14089_((float)((float)Math.toRadians(actingAngle)));
        float xbase = (float)(entity.m_20185_() + (double)((float)offsetX * (-0.5f + v * 0.5f + h * 0.5f)));
        float ybase = (float)(entity.m_20186_() - (double)(h * 0.5f) + (double)(v * 0.5f));
        float zbase = (float)(entity.m_20189_() + (double)((float)offsetZ * (-0.5f + v * 0.5f + h * 0.5f)));
        int trunkHeight = entity.getDestroyData().trunkHeight;
        float segX = xbase + h * (float)(trunkHeight - 1) * (float)offsetX;
        float segY = ybase + v * (float)(trunkHeight - 1);
        float segZ = zbase + h * (float)(trunkHeight - 1) * (float)offsetZ;
        float maxRadius = (float)entity.getDestroyData().getBranchRadius(0) / 16.0f;
        Vec3 vec3d1 = new Vec3((double)xbase, (double)ybase, (double)zbase);
        Vec3 vec3d2 = new Vec3((double)segX, (double)segY, (double)segZ);
        return level.m_6249_((Entity)entity, new AABB(vec3d1.f_82479_, vec3d1.f_82480_, vec3d1.f_82481_, vec3d2.f_82479_, vec3d2.f_82480_, vec3d2.f_82481_), entity1 -> {
            if (entity1 instanceof LivingEntity && entity1.m_6087_()) {
                AABB axisalignedbb = entity1.m_20191_().m_82400_((double)maxRadius);
                return axisalignedbb.m_82390_(vec3d1) || FalloverAnimationHandler.intersects(axisalignedbb, vec3d1, vec3d2);
            }
            return false;
        }).stream().map(a -> (LivingEntity)a).collect(Collectors.toList());
    }

    public static boolean intersects(AABB axisAlignedBB, Vec3 vec3d, Vec3 otherVec3d) {
        return axisAlignedBB.m_82314_(Math.min(vec3d.f_82479_, otherVec3d.f_82479_), Math.min(vec3d.f_82480_, otherVec3d.f_82480_), Math.min(vec3d.f_82481_, otherVec3d.f_82481_), Math.max(vec3d.f_82479_, otherVec3d.f_82479_), Math.max(vec3d.f_82480_, otherVec3d.f_82480_), Math.max(vec3d.f_82481_, otherVec3d.f_82481_));
    }

    @Override
    public void dropPayload(FallingTreeEntity entity) {
        Level level = entity.m_9236_();
        BlockPos cutPos = entity.getDestroyData().cutPos;
        entity.getPayload().forEach(i -> Block.m_49840_((Level)level, (BlockPos)cutPos, (ItemStack)i));
    }

    @Override
    public boolean shouldDie(FallingTreeEntity entity) {
        boolean dead;
        boolean bl = dead = Math.abs(entity.m_146909_()) >= 160.0f || Math.abs(entity.m_146908_()) >= 160.0f || entity.landed || entity.f_19797_ > 120 + entity.getDestroyData().trunkHeight;
        if (dead) {
            entity.cleanupRootyDirt();
            if (entity.m_9236_().f_46443_) {
                SoundInstanceHandler.stopSoundInstance(entity);
            }
        }
        return dead;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void renderTransform(FallingTreeEntity entity, float entityYaw, float partialTick, PoseStack poseStack) {
        float yaw = Mth.m_14177_((float)MathHelper.angleDegreesInterpolate(entity.f_19859_, entity.m_146908_(), partialTick));
        float pit = Mth.m_14177_((float)MathHelper.angleDegreesInterpolate(entity.f_19860_, entity.m_146909_(), partialTick));
        int radius = entity.getDestroyData().getBranchRadius(0);
        Direction toolDir = entity.getDestroyData().toolDir;
        Vec3 toolVec = new Vec3((double)toolDir.m_122429_(), (double)toolDir.m_122430_(), (double)toolDir.m_122431_()).m_82490_((double)((float)radius / 16.0f));
        poseStack.m_85837_(-toolVec.f_82479_, -toolVec.f_82480_, -toolVec.f_82481_);
        poseStack.m_252781_(Axis.f_252393_.m_252977_(yaw));
        poseStack.m_252781_(Axis.f_252529_.m_252977_(pit));
        poseStack.m_85837_(toolVec.f_82479_, toolVec.f_82480_, toolVec.f_82481_);
        poseStack.m_85837_(-0.5, 0.0, -0.5);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean shouldRender(FallingTreeEntity entity) {
        return true;
    }

    static class HandlerData
    extends DataAnimationHandler {
        float fallSpeed = 0.0f;
        int bounces = 0;
        boolean startSoundPlayed = false;
        boolean fallThroughWaterSoundPlayed = false;
        boolean endSoundPlayed = false;
        HashSet<LivingEntity> entitiesHit = new HashSet();

        HandlerData() {
        }
    }
}

