/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.event.handler;

import com.ferreusveritas.dynamictrees.DynamicTrees;
import com.ferreusveritas.dynamictrees.block.PottedSaplingBlock;
import com.ferreusveritas.dynamictrees.models.baked.BakedModelBlockBonsaiPot;
import com.ferreusveritas.dynamictrees.models.loader.BranchBlockModelLoader;
import com.ferreusveritas.dynamictrees.models.loader.PalmLeavesModelLoader;
import com.ferreusveritas.dynamictrees.models.loader.RootsBlockModelLoader;
import com.ferreusveritas.dynamictrees.models.loader.SurfaceRootBlockModelLoader;
import com.ferreusveritas.dynamictrees.models.loader.ThickBranchBlockModelLoader;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.client.model.geometry.IGeometryLoader;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="dynamictrees", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public final class BakedModelEventHandler {
    public static final ResourceLocation BRANCH = DynamicTrees.location("branch");
    public static final ResourceLocation SURFACE_ROOT = DynamicTrees.location("surface_root");
    public static final ResourceLocation ROOTS = DynamicTrees.location("roots");

    @SubscribeEvent
    public static void onModelRegistryEvent(ModelEvent.RegisterGeometryLoaders event) {
        event.register("branch", (IGeometryLoader)new BranchBlockModelLoader());
        event.register("surface_root", (IGeometryLoader)new SurfaceRootBlockModelLoader());
        event.register("thick_branch", (IGeometryLoader)new ThickBranchBlockModelLoader());
        event.register("roots", (IGeometryLoader)new RootsBlockModelLoader());
        event.register("large_palm_fronds", (IGeometryLoader)new PalmLeavesModelLoader(0));
        event.register("medium_palm_fronds", (IGeometryLoader)new PalmLeavesModelLoader(1));
        event.register("small_palm_fronds", (IGeometryLoader)new PalmLeavesModelLoader(2));
    }

    @SubscribeEvent
    public static void onModelModifyBakingResultResult(ModelEvent.ModifyBakingResult event) {
        event.getModels().computeIfPresent(new ModelResourceLocation(PottedSaplingBlock.REG_NAME, ""), (k, val) -> new BakedModelBlockBonsaiPot((BakedModel)val));
    }
}

