/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.loot.function;

import com.ferreusveritas.dynamictrees.loot.DTLootContextParams;
import com.ferreusveritas.dynamictrees.loot.function.DTLootFunctions;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public final class MultiplySticksCount
extends LootItemConditionalFunction {
    public MultiplySticksCount(LootItemCondition[] conditions) {
        super(conditions);
    }

    public LootItemFunctionType m_7162_() {
        return (LootItemFunctionType)DTLootFunctions.MULTIPLY_STICKS_COUNT.get();
    }

    protected ItemStack m_7372_(ItemStack stack, LootContext context) {
        Integer volume = (Integer)context.m_78953_(DTLootContextParams.VOLUME);
        assert (volume != null);
        stack.m_41764_(stack.m_41613_() * 8 * (volume % 4096) / 4096);
        return stack;
    }

    public static LootItemFunction.Builder multiplySticksCount() {
        return () -> new MultiplySticksCount(new LootItemCondition[0]);
    }

    public static class Serializer
    extends LootItemConditionalFunction.Serializer<MultiplySticksCount> {
        public void serialize(JsonObject json, MultiplySticksCount value, JsonSerializationContext context) {
            super.m_6170_(json, (LootItemConditionalFunction)value, context);
        }

        public MultiplySticksCount deserialize(JsonObject json, JsonDeserializationContext context, LootItemCondition[] conditions) {
            return new MultiplySticksCount(conditions);
        }
    }
}

