/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.models.geometry;

import com.ferreusveritas.dynamictrees.models.baked.BasicBranchBlockBakedModel;
import com.ferreusveritas.dynamictrees.models.baked.ThickBranchBlockBakedModel;
import com.ferreusveritas.dynamictrees.tree.family.Family;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.geometry.IGeometryBakingContext;
import net.minecraftforge.client.model.geometry.IUnbakedGeometry;

@OnlyIn(value=Dist.CLIENT)
public class BranchBlockModelGeometry
implements IUnbakedGeometry<BranchBlockModelGeometry> {
    protected final Set<ResourceLocation> textures = new HashSet<ResourceLocation>();
    protected final ResourceLocation barkTextureLocation;
    protected final ResourceLocation ringsTextureLocation;
    protected final boolean forceThickness;
    protected ResourceLocation familyName;
    protected Family family;
    protected ResourceLocation thickRingsTextureLocation;

    public BranchBlockModelGeometry(@Nullable ResourceLocation barkTextureLocation, @Nullable ResourceLocation ringsTextureLocation, @Nullable ResourceLocation familyName, boolean forceThickness) {
        this.barkTextureLocation = barkTextureLocation;
        this.ringsTextureLocation = ringsTextureLocation;
        this.familyName = familyName;
        this.forceThickness = forceThickness;
    }

    public BakedModel bake(IGeometryBakingContext context, ModelBaker baker, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelState, ItemOverrides overrides, ResourceLocation modelLocation) {
        boolean useThickModel = this.useThickModel(this.setFamily(modelLocation));
        if (!useThickModel) {
            return new BasicBranchBlockBakedModel(context, modelLocation, this.barkTextureLocation, this.ringsTextureLocation, spriteGetter);
        }
        if (this.thickRingsTextureLocation == null) {
            this.thickRingsTextureLocation = this.ringsTextureLocation.m_266382_("_thick");
        }
        return new ThickBranchBlockBakedModel(context, modelLocation, this.barkTextureLocation, this.ringsTextureLocation, this.thickRingsTextureLocation, spriteGetter);
    }

    private ResourceLocation setFamilyName(ResourceLocation modelLocation) {
        if (this.familyName == null) {
            this.familyName = new ResourceLocation(modelLocation.m_135827_(), modelLocation.m_135815_().replace("block/", "").replace("_branch", "").replace("stripped_", ""));
        }
        return this.familyName;
    }

    private Family setFamily(ResourceLocation modelResLoc) {
        if (this.family == null) {
            this.family = (Family)Family.REGISTRY.get(this.setFamilyName(modelResLoc));
        }
        return this.family;
    }

    protected boolean useThickModel(Family family) {
        return this.forceThickness || family.isThick();
    }
}

