/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.resources.loader;

import com.ferreusveritas.dynamictrees.api.TreeRegistry;
import com.ferreusveritas.dynamictrees.api.applier.PropertyApplier;
import com.ferreusveritas.dynamictrees.api.applier.PropertyApplierResult;
import com.ferreusveritas.dynamictrees.api.resource.loading.preparation.JsonRegistryResourceLoader;
import com.ferreusveritas.dynamictrees.block.leaves.LeavesProperties;
import com.ferreusveritas.dynamictrees.block.rooty.SoilHelper;
import com.ferreusveritas.dynamictrees.block.rooty.SoilProperties;
import com.ferreusveritas.dynamictrees.deserialisation.JsonDeserialisers;
import com.ferreusveritas.dynamictrees.deserialisation.JsonPropertyAppliers;
import com.ferreusveritas.dynamictrees.deserialisation.TagKeyJsonPropertyApplier;
import com.ferreusveritas.dynamictrees.growthlogic.GrowthLogicKitConfiguration;
import com.ferreusveritas.dynamictrees.item.Seed;
import com.ferreusveritas.dynamictrees.systems.SeedSaplingRecipe;
import com.ferreusveritas.dynamictrees.systems.fruit.Fruit;
import com.ferreusveritas.dynamictrees.systems.genfeature.GenFeatureConfiguration;
import com.ferreusveritas.dynamictrees.systems.pod.Pod;
import com.ferreusveritas.dynamictrees.tree.species.MangroveSpecies;
import com.ferreusveritas.dynamictrees.tree.species.Species;
import com.ferreusveritas.dynamictrees.util.CommonSetup;
import com.ferreusveritas.dynamictrees.util.JsonMapWrapper;
import com.ferreusveritas.dynamictrees.util.holderset.DTBiomeHolderSet;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ComposterBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class SpeciesResourceLoader
extends JsonRegistryResourceLoader<Species> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final JsonPropertyAppliers<Species> environmentFactorAppliers = new JsonPropertyAppliers<Species>(Species.class);
    private final Map<Species, Float> composterChanceCache = new HashMap<Species, Float>();

    public SpeciesResourceLoader() {
        super(Species.REGISTRY, "species");
    }

    @Override
    public void registerAppliers() {
        this.environmentFactorAppliers.register((PropertyApplier)new TagKeyJsonPropertyApplier(Registries.f_256952_, Species.class, (tagKey, species, factor) -> species.envFactor((TagKey<Biome>)tagKey, factor.floatValue())));
        JsonDeserialisers.register(Species.CommonOverride.class, input -> JsonDeserialisers.BIOME_PREDICATE.deserialise(input).map(biomePredicate -> (world, pos) -> world instanceof LevelReader && biomePredicate.test(((LevelReader)world).m_204166_(pos))));
        this.loadAppliers.register("seed", ResourceLocation.class, this::setSeed).register("generate_seed", Boolean.class, Species::setShouldGenerateSeed).register("generate_sapling", Boolean.class, Species::setShouldGenerateSapling).register("sapling_name", String.class, Species::setSaplingName).register("seed_name", String.class, Species::setSeedName);
        this.commonAppliers.register("always_show_on_waila", Boolean.class, Species::setAlwaysShowOnWaila).register("sapling_sound", SoundType.class, Species::setSaplingSound).register("sapling_shape", VoxelShape.class, Species::setSaplingShape);
        this.gatherDataAppliers.register("sapling_shape", VoxelShape.class, Species::setSaplingShape).register("only_if_loaded", String.class, Species::setOnlyIfLoaded).registerArrayApplier("only_if_loaded", String.class, Species::setOnlyIfLoaded).registerMapApplier("model_overrides", ResourceLocation.class, Species::setModelOverrides).registerMapApplier("texture_overrides", ResourceLocation.class, Species::setTextureOverrides).registerMapApplier("lang_overrides", String.class, Species::setLangOverrides);
        this.reloadAppliers.register("tapering", Float.class, Species::setTapering).register("up_probability", Integer.class, Species::setUpProbability).register("lowest_branch_height", Integer.class, Species::setLowestBranchHeight).register("signal_energy", Float.class, Species::setSignalEnergy).register("growth_rate", Float.class, Species::setGrowthRate).register("soil_longevity", Integer.class, Species::setSoilLongevity).register("max_branch_radius", Integer.class, Species::setMaxBranchRadius).register("transformable", Boolean.class, Species::setTransformable).register("growth_logic_kit", GrowthLogicKitConfiguration.class, Species::setGrowthLogicKit).register("leaves_properties", LeavesProperties.class, Species::setLeavesProperties).register("world_gen_leaf_map_height", Integer.class, Species::setWorldGenLeafMapHeight).register("environment_factors", JsonObject.class, this::applyEnvironmentFactors).register("mega_species", ResourceLocation.class, this::setMegaSpecies).register("can_craft_mega_seed", Boolean.class, Species::setCanCraftMegaSeed).register("seed", Seed.class, (species, seed) -> species.setSeed(() -> seed)).register("seed_composter_chance", Float.class, this.composterChanceCache::put).register("tint_sapling", Boolean.class, Species::setTintSapling).register("sapling_grows_naturally", Boolean.class, Species::setCanSaplingGrowNaturally).register("primitive_sapling", SeedSaplingRecipe.class, Species::addPrimitiveSaplingRecipe).registerArrayApplier("primitive_saplings", SeedSaplingRecipe.class, Species::addPrimitiveSaplingRecipe).register("common_override", Species.CommonOverride.class, Species::setCommonOverride).register("perfect_biomes", DTBiomeHolderSet.class, (species, biomeList) -> species.getPerfectBiomes().getIncludeComponents().add(biomeList)).register("can_bone_meal_tree", Boolean.class, Species::setCanBoneMealTree).registerArrayApplier("acceptable_growth_blocks", Block.class, Species::addAcceptableBlockForGrowth).registerArrayApplier("acceptable_soils", String.class, this::addAcceptableSoil).registerArrayApplier("world_gen_acceptable_soils", String.class, this::addAcceptableSoilForWorldGen).register("force_soil", SoilProperties.class, Species::setForceSoil).registerListApplier("fruits", Fruit.class, Species::addFruits).registerListApplier("pods", Pod.class, Species::addPods).registerArrayApplier("features", GenFeatureConfiguration.class, Species::addGenFeature).register("does_rot", Boolean.class, Species::setDoesRot).register("drop_seeds", Boolean.class, Species::setDropSeeds).register("seasonal_seed_drop_offset", Float.class, Species::setSeasonalSeedDropOffset).register("seasonal_growth_offset", Float.class, Species::setSeasonalGrowthOffset).register("seasonal_fruiting_offset", Float.class, Species::setSeasonalFruitingOffset).register("inherit_fruiting_offset_to_fruits", Boolean.class, (species, doInherit) -> {
            if (doInherit.booleanValue()) {
                Species.REGISTRY.runOnNextLock(species::inheritSeasonalFruitingOffsetToFruits);
            }
        }).register("inherit_fruiting_offset_to_pods", Boolean.class, (species, doInherit) -> {
            if (doInherit.booleanValue()) {
                Species.REGISTRY.runOnNextLock(species::inheritSeasonalFruitingOffsetToPods);
            }
        }).register("big_tree_sound_threshold", Float.class, Species::setBigTreeSoundThreshold).register("plantable_on_fluid", Boolean.class, Species::setPlantableOnFluid).register("allowed_water_height_for_world_gen", Integer.class, Species::setAllowedWaterHeightForWorldgen);
        this.registerMangroveAppliers();
        super.registerAppliers();
    }

    private void registerMangroveAppliers() {
        this.reloadAppliers.register("min_world_gen_height_offset", MangroveSpecies.class, Integer.class, MangroveSpecies::setMinWorldGenHeightOffset).register("max_world_gen_height_offset", MangroveSpecies.class, Integer.class, MangroveSpecies::setMaxWorldGenHeightOffset).register("roots_growth_logic_kit", MangroveSpecies.class, GrowthLogicKitConfiguration.class, MangroveSpecies::setRootsGrowthLogicKit).register("root_growth_multiplier", MangroveSpecies.class, Integer.class, MangroveSpecies::setRootGrowthMultiplier).register("root_tapering", MangroveSpecies.class, Float.class, MangroveSpecies::setRootTapering).register("root_signal_energy", MangroveSpecies.class, Float.class, MangroveSpecies::setRootSignalEnergy).register("update_soil_on_water_radius", MangroveSpecies.class, Integer.class, MangroveSpecies::setUpdateSoilOnWaterRadius);
    }

    private void setSeed(Species species, ResourceLocation seedName) {
        ResourceLocation processedSeedName = TreeRegistry.processResLoc(seedName);
        species.setShouldGenerateSeed(false);
        species.setShouldGenerateSapling(false);
        CommonSetup.runOnCommonSetup(event -> {
            Item seed = (Item)ForgeRegistries.ITEMS.getValue(processedSeedName);
            if (seed instanceof Seed) {
                species.setSeed(() -> (Seed)seed);
            } else {
                LOGGER.warn("Could not find valid seed item from registry name \"" + String.valueOf(seedName) + "\".");
            }
        });
    }

    private void applyEnvironmentFactors(Species species, JsonObject jsonObject) {
        this.environmentFactorAppliers.applyAll(new JsonMapWrapper(jsonObject), species).forEachErrorWarning(error -> LOGGER.error("Error applying environment factor for species '{}': {}", (Object)species.getRegistryName(), error), warning -> LOGGER.warn("Warning applying environment factor for species '{}': {}", (Object)species.getRegistryName(), warning));
    }

    private void setMegaSpecies(Species species, ResourceLocation registryName) {
        ResourceLocation processedRegName = TreeRegistry.processResLoc(registryName);
        Species.REGISTRY.runOnNextLock(Species.REGISTRY.generateIfValidRunnable(processedRegName, species::setMegaSpecies, () -> LOGGER.warn("Could not set mega species for '" + String.valueOf(species) + "' as Species '" + String.valueOf(processedRegName) + "' was not found.")));
    }

    private PropertyApplierResult addAcceptableSoil(Species species, String acceptableSoil) {
        return SoilHelper.applyIfSoilIsAcceptable(species, acceptableSoil, (rec$, xva$0) -> ((Species)rec$).addAcceptableSoils((String)xva$0));
    }

    private PropertyApplierResult addAcceptableSoilForWorldGen(Species species, String acceptableSoil) {
        return SoilHelper.applyIfSoilIsAcceptable(species, acceptableSoil, (rec$, xva$0) -> ((Species)rec$).addAcceptableSoilsForWorldGen((String)xva$0));
    }

    @Override
    protected void postLoadOnLoad(JsonRegistryResourceLoader.LoadData loadData, JsonObject json) {
        super.postLoadOnLoad(loadData, json);
        ((Species)loadData.getResource()).generateSeed().generateSapling();
    }

    @Override
    protected void postLoadOnReload(JsonRegistryResourceLoader.LoadData loadData, JsonObject json) {
        Species species = (Species)loadData.getResource();
        this.composterChanceCache.put(species, Float.valueOf(species.defaultSeedComposterChance()));
        super.postLoadOnReload(loadData, json);
        this.registerComposterChances();
    }

    private void registerComposterChances() {
        this.composterChanceCache.forEach((species, chance) -> {
            if (species.getSeed().isPresent() && chance.floatValue() > 0.0f) {
                ComposterBlock.m_51920_((float)chance.floatValue(), (ItemLike)((ItemLike)species.getSeed().get()));
            }
        });
        this.composterChanceCache.clear();
    }
}

