/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.systems;

import com.ferreusveritas.dynamictrees.DynamicTrees;
import com.ferreusveritas.dynamictrees.tree.family.Family;
import com.ferreusveritas.dynamictrees.util.function.TetraFunction;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class BranchConnectables {
    private static final Map<Block, Map<ResourceLocation, TetraFunction<BlockState, BlockGetter, BlockPos, Direction, Integer>>> connectablesMap = new HashMap<Block, Map<ResourceLocation, TetraFunction<BlockState, BlockGetter, BlockPos, Direction, Integer>>>();

    public static void makeBlockConnectable(Block block, TetraFunction<BlockState, BlockGetter, BlockPos, Direction, Integer> radiusFunction, ResourceLocation family) {
        Map map = connectablesMap.computeIfAbsent(block, k -> new HashMap());
        map.putIfAbsent(family, radiusFunction);
    }

    public static void makeBlockConnectable(Block block, TetraFunction<BlockState, BlockGetter, BlockPos, Direction, Integer> radiusFunction) {
        BranchConnectables.makeBlockConnectable(block, radiusFunction, DynamicTrees.location("null"));
    }

    public static void replaceBlockConnectable(Block block, TetraFunction<BlockState, BlockGetter, BlockPos, Direction, Integer> radiusFunction, ResourceLocation family) {
        Map map = connectablesMap.computeIfAbsent(block, k -> new HashMap());
        map.remove(family);
        map.put(family, radiusFunction);
    }

    public static boolean isBlockConnectable(Block block) {
        return connectablesMap.containsKey(block);
    }

    public static int getConnectionRadiusForBlock(BlockState state, BlockGetter world, BlockPos pos, @Nullable Direction side, Family family) {
        Block block = state.m_60734_();
        if (BranchConnectables.isBlockConnectable(block)) {
            TetraFunction<BlockState, BlockGetter, BlockPos, Direction, Integer> function = BranchConnectables.getFunctionForFamily(block, family);
            if (function == null) {
                return 0;
            }
            return function.apply(state, world, pos, side);
        }
        return 0;
    }

    public static int getConnectionRadiusForBlock(BlockState state, BlockGetter world, BlockPos pos, @Nullable Direction side) {
        return BranchConnectables.getConnectionRadiusForBlock(state, world, pos, side, Family.NULL_FAMILY);
    }

    @Nullable
    private static TetraFunction<BlockState, BlockGetter, BlockPos, Direction, Integer> getFunctionForFamily(Block block, Family family) {
        Map<ResourceLocation, TetraFunction<BlockState, BlockGetter, BlockPos, Direction, Integer>> familyMap = connectablesMap.get(block);
        if (familyMap == null) {
            return null;
        }
        TetraFunction<BlockState, BlockGetter, BlockPos, Direction, Integer> function = familyMap.get(family.getRegistryName());
        if (function == null) {
            function = familyMap.get(DynamicTrees.location("null"));
        }
        return function;
    }
}

