/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.systems.genfeature;

import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.configuration.ConfigurationProperty;
import com.ferreusveritas.dynamictrees.data.DTBiomeTags;
import com.ferreusveritas.dynamictrees.systems.genfeature.GenFeature;
import com.ferreusveritas.dynamictrees.systems.genfeature.GenFeatureConfiguration;
import com.ferreusveritas.dynamictrees.systems.genfeature.context.PostGenerationContext;
import com.ferreusveritas.dynamictrees.systems.genfeature.context.PostGrowContext;
import com.ferreusveritas.dynamictrees.util.CoordUtils;
import com.ferreusveritas.dynamictrees.util.function.CanGrowPredicate;
import java.util.LinkedList;
import java.util.List;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BeehiveBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.apache.commons.lang3.tuple.Pair;

public class BeeNestGenFeature
extends GenFeature {
    public static final ConfigurationProperty<Block> NEST_BLOCK = ConfigurationProperty.block("nest");
    public static final ConfigurationProperty<WorldGenChanceFunction> WORLD_GEN_CHANCE_FUNCTION = ConfigurationProperty.property("world_gen_chance", WorldGenChanceFunction.class);
    private static final double GUARANTEED_CHANCE = 1.0;
    private static final double COMMON_CHANCE = 0.05;
    private static final double UNCOMMON_CHANCE = 0.02;
    private static final double RARE_CHANCE = 2.0E-4;
    private static final double GROW_CHANCE = 0.001;

    public BeeNestGenFeature(ResourceLocation registryName) {
        super(registryName);
    }

    @Override
    protected void registerProperties() {
        this.register(NEST_BLOCK, MAX_HEIGHT, CAN_GROW_PREDICATE, WORLD_GEN_CHANCE_FUNCTION, MAX_COUNT);
    }

    @Override
    public GenFeatureConfiguration createDefaultConfiguration() {
        return (GenFeatureConfiguration)((GenFeatureConfiguration)((GenFeatureConfiguration)((GenFeatureConfiguration)((GenFeatureConfiguration)super.createDefaultConfiguration().with(NEST_BLOCK, Blocks.f_50717_)).with(MAX_HEIGHT, 32)).with(CAN_GROW_PREDICATE, (world, pos) -> {
            if ((double)world.m_213780_().m_188501_() > 0.001) {
                return false;
            }
            for (BlockPos blockpos : BlockPos.m_121940_((BlockPos)pos.m_7495_().m_122013_(2).m_122025_(2), (BlockPos)pos.m_7494_().m_122020_(2).m_122030_(2))) {
                if (!world.m_8055_(blockpos).m_204336_(BlockTags.f_13041_)) continue;
                return true;
            }
            return false;
        })).with(WORLD_GEN_CHANCE_FUNCTION, (world, pos) -> {
            Holder biomeHolder = world.m_203675_(pos.m_123341_() >> 2, pos.m_123342_() >> 2, pos.m_123343_() >> 2);
            if (biomeHolder.m_203656_(DTBiomeTags.IS_BEE_NEST_GUARANTEED)) {
                return 1.0;
            }
            if (biomeHolder.m_203656_(DTBiomeTags.IS_BEE_NEST_COMMON)) {
                return 0.05;
            }
            if (biomeHolder.m_203656_(DTBiomeTags.IS_BEE_NEST_UNCOMMON)) {
                return 0.02;
            }
            return biomeHolder.m_203656_(DTBiomeTags.IS_BEE_NEST_RARE) ? 2.0E-4 : 0.0;
        })).with(MAX_COUNT, 1);
    }

    @Override
    protected boolean postGenerate(GenFeatureConfiguration configuration, PostGenerationContext context) {
        LevelAccessor world = context.level();
        BlockPos rootPos = context.pos();
        return (double)world.m_213780_().m_188501_() <= (Double)configuration.get(WORLD_GEN_CHANCE_FUNCTION).apply(world, rootPos) && this.placeBeeNestInValidPlace(configuration, world, rootPos, true, context.random());
    }

    @Override
    protected boolean postGrow(GenFeatureConfiguration configuration, PostGrowContext context) {
        if (!context.natural() || !((CanGrowPredicate)configuration.get(CAN_GROW_PREDICATE)).test(context.level(), context.pos().m_7494_()) || context.fertility() == 0) {
            return false;
        }
        return this.placeBeeNestInValidPlace(configuration, context.level(), context.pos(), false, context.random());
    }

    private boolean placeBeeNestInValidPlace(GenFeatureConfiguration configuration, LevelAccessor world, BlockPos rootPos, boolean worldGen, RandomSource random) {
        int treeHeight;
        Block nestBlock = configuration.get(NEST_BLOCK);
        if (this.nestAlreadyPresent(world, nestBlock, rootPos, treeHeight = this.getTreeHeight(world, rootPos, (Integer)configuration.get(MAX_HEIGHT)))) {
            return false;
        }
        List<Pair<BlockPos, List<Direction>>> validSpaces = this.findBranchPits(configuration, world, rootPos, treeHeight);
        if (validSpaces == null) {
            return false;
        }
        if (validSpaces.size() > 0) {
            Pair<BlockPos, List<Direction>> chosenSpace = validSpaces.get(world.m_213780_().m_188503_(validSpaces.size()));
            Direction chosenDir = (Direction)((List)chosenSpace.getValue()).get(world.m_213780_().m_188503_(((List)chosenSpace.getValue()).size()));
            return this.placeBeeNestWithBees(world, nestBlock, (BlockPos)chosenSpace.getKey(), chosenDir, worldGen, random);
        }
        return false;
    }

    private boolean placeBeeNestWithBees(LevelAccessor world, Block nestBlock, BlockPos pos, Direction faceDir, boolean worldGen, RandomSource random) {
        BlockState nestState = nestBlock.m_49966_();
        if (nestState.m_61138_((Property)BeehiveBlock.f_49563_)) {
            nestState = (BlockState)nestState.m_61124_((Property)BeehiveBlock.f_49563_, (Comparable)faceDir);
        }
        world.m_7731_(pos, nestState, 3);
        world.m_141902_(pos, BlockEntityType.f_58912_).ifPresent(blockEntity -> {
            int j = 2 + random.m_188503_(2);
            for (int k = 0; k < j; ++k) {
                CompoundTag compoundtag = new CompoundTag();
                compoundtag.m_128359_("id", BuiltInRegistries.f_256780_.m_7981_((Object)EntityType.f_20550_).toString());
                blockEntity.m_155157_(compoundtag, random.m_188503_(599), false);
            }
        });
        return true;
    }

    @Nullable
    private Level worldFromIWorld(LevelAccessor iWorld) {
        if (iWorld instanceof WorldGenRegion) {
            return ((WorldGenRegion)iWorld).m_6018_();
        }
        if (iWorld instanceof Level) {
            return (Level)iWorld;
        }
        return null;
    }

    private boolean nestAlreadyPresent(LevelAccessor world, Block nestBlock, BlockPos rootPos, int maxHeight) {
        for (int y = 2; y < maxHeight; ++y) {
            BlockPos trunkPos = rootPos.m_6630_(y);
            for (Direction dir : CoordUtils.HORIZONTALS) {
                if (world.m_8055_(trunkPos.m_121945_(dir)).m_60734_() != nestBlock) continue;
                return true;
            }
        }
        return false;
    }

    private int getTreeHeight(LevelAccessor world, BlockPos rootPos, int maxHeight) {
        for (int i = 1; i < maxHeight; ++i) {
            if (TreeHelper.isBranch(world.m_8055_(rootPos.m_6630_(i)))) continue;
            return i - 1;
        }
        return maxHeight;
    }

    @Nullable
    private List<Pair<BlockPos, List<Direction>>> findBranchPits(GenFeatureConfiguration configuration, LevelAccessor world, BlockPos rootPos, int maxHeight) {
        int existingBlocks = 0;
        LinkedList<Pair<BlockPos, List<Direction>>> validSpaces = new LinkedList<Pair<BlockPos, List<Direction>>>();
        for (int y = 2; y < maxHeight; ++y) {
            BlockPos trunkPos = rootPos.m_6630_(y);
            for (Direction dir : CoordUtils.HORIZONTALS) {
                BlockPos sidePos = trunkPos.m_121945_(dir);
                if (world.m_46859_(sidePos) && TreeHelper.isBranch(world.m_8055_(sidePos.m_7494_()))) {
                    LinkedList<Direction> validDirs = new LinkedList<Direction>();
                    for (Direction dir2 : CoordUtils.HORIZONTALS) {
                        if (!world.m_46859_(sidePos.m_121945_(dir2))) continue;
                        validDirs.add(dir2);
                    }
                    if (validDirs.size() <= 0) continue;
                    validSpaces.add((Pair<BlockPos, List<Direction>>)Pair.of((Object)sidePos, validDirs));
                    continue;
                }
                if (world.m_8055_(sidePos).m_60734_() != configuration.get(NEST_BLOCK) || ++existingBlocks <= (Integer)configuration.get(MAX_COUNT)) continue;
                return null;
            }
        }
        return validSpaces;
    }

    public static interface WorldGenChanceFunction
    extends BiFunction<LevelAccessor, BlockPos, Double> {
    }
}

