/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.systems.nodemapper;

import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.network.NodeInspector;
import com.ferreusveritas.dynamictrees.api.treedata.TreePart;
import com.ferreusveritas.dynamictrees.block.branch.BranchBlock;
import com.ferreusveritas.dynamictrees.block.rooty.RootyBlock;
import com.ferreusveritas.dynamictrees.tree.species.Species;
import com.ferreusveritas.dynamictrees.util.SimpleVoxmap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;

public class InflatorNode
implements NodeInspector {
    private float radius;
    private BlockPos last;
    private BlockPos highestTrunkBlock;
    private int maxRadius;
    Species species;
    SimpleVoxmap leafMap;

    public InflatorNode(Species species, SimpleVoxmap leafMap) {
        this(species, leafMap, species.getMaxBranchRadius());
    }

    public InflatorNode(Species species, SimpleVoxmap leafMap, int maxRadius) {
        this.species = species;
        this.leafMap = leafMap;
        this.last = BlockPos.f_121853_;
        this.highestTrunkBlock = null;
        this.maxRadius = Math.min(maxRadius, species.getMaxBranchRadius());
    }

    @Override
    public boolean run(BlockState state, LevelAccessor level, BlockPos pos, Direction fromDir) {
        BranchBlock branch = TreeHelper.getBranch(state);
        if (branch != null) {
            this.radius = this.species.getFamily().getPrimaryThickness();
            if (this.highestTrunkBlock == null && !TreeHelper.isBranch(level.m_8055_(pos.m_7494_()))) {
                this.highestTrunkBlock = pos;
            }
        }
        return false;
    }

    @Override
    public boolean returnRun(BlockState state, LevelAccessor level, BlockPos pos, Direction fromDir) {
        BranchBlock branch = TreeHelper.getBranch(state);
        if (branch != null) {
            float areaAccum = this.radius * this.radius;
            boolean isTwig = true;
            for (Direction dir : Direction.values()) {
                if (dir.equals((Object)fromDir)) continue;
                BlockPos dPos = pos.m_121945_(dir);
                if (dPos.equals((Object)this.last)) {
                    isTwig = false;
                    continue;
                }
                BlockState deltaBlockState = level.m_8055_(dPos);
                TreePart treepart = TreeHelper.getTreePart(deltaBlockState);
                if (!branch.isSameTree(treepart)) continue;
                int branchRadius = treepart.getRadius(deltaBlockState);
                areaAccum += (float)(branchRadius * branchRadius);
            }
            if (isTwig) {
                if (this.leafMap != null) {
                    this.leafMap.setVoxel(pos, (byte)16);
                    SimpleVoxmap leafCluster = this.species.getLeavesProperties().getCellKit().getLeafCluster();
                    this.leafMap.blitMax(pos, leafCluster);
                }
            } else {
                float secondaryThickness;
                this.radius = (float)Math.sqrt(areaAccum) + this.species.getTapering() * this.species.getWorldGenTaperingFactor();
                if (this.radius > (float)this.maxRadius) {
                    this.radius = this.maxRadius;
                }
                if (this.highestTrunkBlock != null) {
                    boolean isInTrunk;
                    int blockRadius = 8;
                    boolean bl = isInTrunk = pos.m_123341_() == this.highestTrunkBlock.m_123341_() && pos.m_123342_() <= this.highestTrunkBlock.m_123342_() && pos.m_123343_() == this.highestTrunkBlock.m_123343_();
                    if (this.radius > (float)blockRadius && !isInTrunk) {
                        this.radius = blockRadius;
                    }
                }
                if (this.radius < (secondaryThickness = (float)this.species.getFamily().getSecondaryThickness())) {
                    this.radius = secondaryThickness;
                }
                branch.setRadius(level, pos, (int)Math.floor(this.radius), null);
                if (this.leafMap != null) {
                    this.leafMap.setVoxel(pos, (byte)32);
                }
            }
            this.last = pos;
        } else {
            RootyBlock rooty = TreeHelper.getRooty(state);
            if (rooty != null) {
                rooty.updateRadius(level, state, pos, 2, false);
            }
        }
        return false;
    }
}

