/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.systems.substance;

import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.substance.SubstanceEffect;
import com.ferreusveritas.dynamictrees.block.rooty.RootyBlock;
import com.ferreusveritas.dynamictrees.compat.waila.WailaOther;
import com.ferreusveritas.dynamictrees.tree.species.Species;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;

public class MegaSubstance
implements SubstanceEffect {
    @Override
    public boolean apply(Level level, BlockPos rootPos) {
        BlockState blockState = level.m_8055_(rootPos);
        RootyBlock dirt = TreeHelper.getRooty(blockState);
        Species species = dirt.getSpecies(blockState, (LevelAccessor)level, rootPos);
        Species megaSpecies = species.getMegaSpecies();
        if (megaSpecies.isValid()) {
            int fertility = dirt.getFertility(blockState, (BlockGetter)level, rootPos);
            megaSpecies.placeRootyDirtBlock((LevelAccessor)level, rootPos, fertility);
            blockState = level.m_8055_(rootPos);
            dirt = TreeHelper.getRooty(blockState);
            if (dirt.getSpecies(blockState, (LevelAccessor)level, rootPos) == megaSpecies) {
                TreeHelper.treeParticles(level, rootPos, ParticleTypes.f_123799_, 8);
                WailaOther.invalidateWailaPosition();
                return true;
            }
        }
        return false;
    }

    @Override
    public String getName() {
        return "mega";
    }

    @Override
    public boolean isLingering() {
        return false;
    }
}

