/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.util;

import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.network.MapSignal;
import com.ferreusveritas.dynamictrees.block.FruitBlock;
import com.ferreusveritas.dynamictrees.block.PodBlock;
import com.ferreusveritas.dynamictrees.block.branch.BranchBlock;
import com.ferreusveritas.dynamictrees.block.branch.SurfaceRootBlock;
import com.ferreusveritas.dynamictrees.block.rooty.RootyBlock;
import com.ferreusveritas.dynamictrees.entity.FallingTreeEntity;
import com.ferreusveritas.dynamictrees.systems.nodemapper.CollectorNode;
import com.ferreusveritas.dynamictrees.util.BlockBounds;
import com.ferreusveritas.dynamictrees.util.BlockStates;
import com.ferreusveritas.dynamictrees.util.BranchDestructionData;
import com.ferreusveritas.dynamictrees.util.SimpleVoxmap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.VineBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;

public class ChunkTreeHelper {
    private static final int CHUNK_WIDTH = 16;
    private static final byte NONE = 0;
    private static final byte TREE = 1;
    private static final byte SURR = 2;

    public static int removeOrphanedBranchNodes(Level level, @Nullable ChunkPos chunkPos, int radius) {
        if (chunkPos == null) {
            throw new NullPointerException("Null chunk position");
        }
        HashSet<BlockPos> found = new HashSet<BlockPos>();
        BlockBounds bounds = ChunkTreeHelper.getEffectiveBlockBounds(level, chunkPos, radius);
        int orphansCleared = 0;
        for (BlockPos pos : bounds) {
            Direction trunkDir;
            BlockPos trunkPos;
            BlockState trunkState;
            Optional<BranchBlock> trunk;
            BlockState state = level.m_8055_(pos);
            Optional<BranchBlock> branchBlock = TreeHelper.getBranchOpt(state);
            if (branchBlock.isEmpty()) continue;
            BlockPos rootPos = TreeHelper.findRootNode(level, pos);
            if (rootPos == BlockPos.f_121853_) {
                ChunkTreeHelper.doTreeDestroy(level, branchBlock.get(), pos);
                ++orphansCleared;
                continue;
            }
            BlockState rootyState = level.m_8055_(rootPos);
            Optional<RootyBlock> rootyBlock = TreeHelper.getRootyOpt(rootyState);
            if (rootyBlock.isEmpty() || (trunk = TreeHelper.getBranchOpt(trunkState = level.m_8055_(trunkPos = rootPos.m_121945_(trunkDir = rootyBlock.get().getTrunkDirection((BlockGetter)level, rootPos))))).isEmpty()) continue;
            MapSignal signal = new MapSignal();
            signal.destroyLoopedNodes = false;
            trunk.get().analyse(trunkState, (LevelAccessor)level, trunkPos, null, signal);
            if (signal.multiroot || signal.overflow) {
                ChunkTreeHelper.doTreeDestroy(level, branchBlock.get(), pos);
                ++orphansCleared;
                continue;
            }
            trunk.get().analyse(trunkState, (LevelAccessor)level, trunkPos, null, new MapSignal(new CollectorNode(found)));
        }
        return orphansCleared;
    }

    public static int removeAllBranchesFromChunk(Level level, @Nullable ChunkPos chunkPos, int radius) {
        if (chunkPos == null) {
            throw new NullPointerException("Null chunk position");
        }
        BlockBounds bounds = ChunkTreeHelper.getEffectiveBlockBounds(level, chunkPos, radius);
        AtomicInteger treesCleared = new AtomicInteger();
        for (BlockPos pos : bounds) {
            BlockState state = level.m_8055_(pos);
            TreeHelper.getBranchOpt(state).ifPresent(branchBlock -> {
                ChunkTreeHelper.doTreeDestroy(level, branchBlock, pos);
                treesCleared.getAndIncrement();
            });
        }
        return treesCleared.get();
    }

    public static BlockBounds getEffectiveBlockBounds(Level level, ChunkPos chunkPos, int radius) {
        LevelChunk chunk = level.m_6325_(chunkPos.f_45578_, chunkPos.f_45579_);
        BlockBounds bounds = new BlockBounds((LevelAccessor)level, chunkPos);
        bounds.shrink(Direction.UP, level.m_141928_() - 1 - (ChunkTreeHelper.getTopFilledSegment(chunk) + 16));
        for (Direction dir : Direction.Plane.HORIZONTAL.m_122557_().toList()) {
            bounds.expand(dir, radius * 16);
        }
        return bounds;
    }

    private static int getTopFilledSegment(LevelChunk chunk) {
        return chunk.m_62098_();
    }

    private static void doTreeDestroy(Level level, BranchBlock branchBlock, BlockPos pos) {
        BranchDestructionData destroyData = branchBlock.destroyBranchFromNode(level, pos, Direction.DOWN, true, null);
        destroyData.leavesDrops.clear();
        FallingTreeEntity.dropTree(level, destroyData, new ArrayList<ItemStack>(0), FallingTreeEntity.DestroyType.ROOT);
        ChunkTreeHelper.cleanupNeighbors(level, destroyData);
    }

    public static void cleanupNeighbors(Level level, BranchDestructionData destroyData) {
        if (level.f_46443_) {
            return;
        }
        BlockBounds treeBounds = new BlockBounds(destroyData.cutPos);
        destroyData.getPositions(BranchDestructionData.PosType.LEAVES, true).forEach(treeBounds::union);
        destroyData.getPositions(BranchDestructionData.PosType.BRANCHES, true).forEach(treeBounds::union);
        treeBounds.expand(1);
        SimpleVoxmap treeVoxmap = new SimpleVoxmap(treeBounds);
        destroyData.getPositions(BranchDestructionData.PosType.LEAVES, true).forEach(pos -> treeVoxmap.setVoxel((BlockPos)pos, (byte)1));
        destroyData.getPositions(BranchDestructionData.PosType.BRANCHES, true).forEach(pos -> treeVoxmap.setVoxel((BlockPos)pos, (byte)1));
        SimpleVoxmap outlineVoxmap = new SimpleVoxmap(treeVoxmap);
        treeVoxmap.getAllNonZero((byte)1).forEach(pos -> {
            for (Direction dir : Direction.values()) {
                outlineVoxmap.setVoxel((BlockPos)pos.m_122193_(dir.m_122436_()), (byte)2);
            }
        });
        treeVoxmap.getAllNonZero((byte)1).forEach(pos -> outlineVoxmap.setVoxel((BlockPos)pos, (byte)0));
        outlineVoxmap.getAllNonZero((byte)2).forEach(pos -> ChunkTreeHelper.cleanupBlock(level, (BlockPos)pos));
    }

    public static void cleanupBlock(Level level, BlockPos pos) {
        BlockState state = level.m_8055_(pos);
        if (state.m_60734_() == Blocks.f_50016_) {
            return;
        }
        Block block = state.m_60734_();
        if (block instanceof SnowLayerBlock || block instanceof FruitBlock || block instanceof PodBlock || block instanceof SurfaceRootBlock) {
            level.m_7731_(pos, BlockStates.AIR, 2);
        } else if (block instanceof VineBlock) {
            ChunkTreeHelper.cleanupVines(level, pos);
        }
    }

    public static void cleanupVines(Level level, BlockPos pos) {
        BlockPos.MutableBlockPos mblock = pos.m_122032_();
        while (level.m_8055_((BlockPos)mblock).m_60734_() instanceof VineBlock) {
            level.m_7731_((BlockPos)mblock, BlockStates.AIR, 2);
            mblock.m_122173_(Direction.DOWN);
        }
    }
}

