/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.worldgen.biomemodifiers;

import com.ferreusveritas.dynamictrees.api.worldgen.BiomePropertySelectors;
import com.ferreusveritas.dynamictrees.api.worldgen.FeatureCanceller;
import com.ferreusveritas.dynamictrees.init.DTConfigs;
import com.ferreusveritas.dynamictrees.init.DTRegistries;
import com.ferreusveritas.dynamictrees.worldgen.BiomeDatabase;
import com.ferreusveritas.dynamictrees.worldgen.FeatureCancellationRegistry;
import com.mojang.serialization.Codec;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraftforge.common.world.BiomeGenerationSettingsBuilder;
import net.minecraftforge.common.world.BiomeModifier;
import net.minecraftforge.common.world.ModifiableBiomeInfo;

public class RunFeatureCancellersBiomeModifier
implements BiomeModifier {
    public static final TagKey<PlacedFeature> FEATURE_CANCELLER_EXCLUSIONS_KEY = TagKey.m_203882_((ResourceKey)Registries.f_256988_, (ResourceLocation)new ResourceLocation("dynamictrees", "feature_canceller_exclusions"));

    public void modify(Holder<Biome> biome, BiomeModifier.Phase phase, ModifiableBiomeInfo.BiomeInfo.Builder builder) {
        if (phase == BiomeModifier.Phase.REMOVE && ((Boolean)DTConfigs.WORLD_GEN.get()).booleanValue()) {
            ResourceKey biomeKey = (ResourceKey)biome.m_203543_().orElseThrow();
            BiomeGenerationSettingsBuilder generationSettings = builder.getGenerationSettings();
            BiomePropertySelectors.NormalFeatureCancellation featureCancellations = new BiomePropertySelectors.NormalFeatureCancellation();
            for (FeatureCancellationRegistry.Entry entry : FeatureCancellationRegistry.getCancellations()) {
                if (!entry.biomes().containsKey((ResourceKey<Biome>)biomeKey)) continue;
                if (entry.operation() == BiomeDatabase.Operation.REPLACE) {
                    featureCancellations.reset();
                }
                featureCancellations.addFrom(entry.cancellations());
            }
            featureCancellations.getDecorationSteps().forEach(stage -> generationSettings.getFeatures(stage).removeIf(placedFeatureHolder -> {
                if (placedFeatureHolder.m_203656_(FEATURE_CANCELLER_EXCLUSIONS_KEY)) {
                    return false;
                }
                PlacedFeature placedFeature = (PlacedFeature)placedFeatureHolder.m_203334_();
                return placedFeature.m_191781_().anyMatch(configuredFeature -> {
                    for (FeatureCanceller featureCanceller : featureCancellations.getCancellers()) {
                        if (!featureCanceller.shouldCancel((ConfiguredFeature<?, ?>)configuredFeature, featureCancellations)) continue;
                        return true;
                    }
                    return false;
                });
            }));
        }
    }

    public Codec<? extends BiomeModifier> codec() {
        return (Codec)DTRegistries.RUN_FEATURE_CANCELLERS_BIOME_MODIFIER.get();
    }
}

