/*
 * Decompiled with CFR 0.152.
 */
package com.lazrproductions.lazrslib.client.ui.element;

import com.lazrproductions.lazrslib.client.font.FontUtilities;
import com.lazrproductions.lazrslib.client.screen.ScreenUtilities;
import com.lazrproductions.lazrslib.client.screen.base.ScreenRect;
import com.lazrproductions.lazrslib.client.screen.base.ScreenTexture;
import com.lazrproductions.lazrslib.client.ui.OnClickFunction;
import com.lazrproductions.lazrslib.client.ui.element.AbstractElement;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;

public class BulletLinkListElement
extends AbstractElement {
    static final int LIST_ICON_SIZE = 16;
    static final int LIST_ITEM_PADDING = 7;
    final int width;
    final ScreenTexture bulletTexture;
    final List<Pair<Component, OnClickFunction>> itemList;
    final int textColor;
    final int highlightedColor;
    final boolean renderShadow;

    public BulletLinkListElement(@Nonnull Minecraft instance, int width, @Nonnull ScreenTexture bulletTexture, @Nonnull List<Pair<Component, OnClickFunction>> list, int textColor, int highlightedColor) {
        super(instance, BulletLinkListElement.getTotalHeight(instance, width, list));
        this.width = width;
        this.bulletTexture = bulletTexture;
        this.itemList = list;
        this.textColor = textColor;
        this.highlightedColor = highlightedColor;
        this.renderShadow = true;
    }

    public BulletLinkListElement(@Nonnull Minecraft instance, int width, @Nonnull ScreenTexture bulletTexture, @Nonnull List<Pair<Component, OnClickFunction>> list, int textColor, int highlightedColor, boolean renderShadow) {
        super(instance, BulletLinkListElement.getTotalHeight(instance, width, list));
        this.width = width;
        this.bulletTexture = bulletTexture;
        this.itemList = list;
        this.textColor = textColor;
        this.highlightedColor = highlightedColor;
        this.renderShadow = renderShadow;
    }

    @Override
    public void draw(@Nonnull Minecraft instance, @Nonnull GuiGraphics graphics, @Nonnull ScreenRect area, int mouseX, int mouseY, boolean mouseDown) {
        int clicked = -1;
        int totalHeight = 0;
        for (int i = 0; i < this.itemList.size(); ++i) {
            ScreenUtilities.drawTexture(graphics, area.toBlitCoordinates().move(-4, totalHeight).withWidth(16).withHeight(16), this.bulletTexture);
            int localHeight = instance.f_91062_.m_239133_((FormattedText)this.itemList.get(i).getFirst(), this.width - 12);
            if (FontUtilities.drawLinkWrapped(instance, graphics, area.toBlitCoordinates().move(12, totalHeight).withWidth(area.toBlitCoordinates().getWidth() - 12).withHeight(localHeight), (Component)this.itemList.get(i).getFirst(), this.textColor, this.highlightedColor, this.renderShadow, mouseX, mouseY, mouseDown)) {
                clicked = i;
            }
            totalHeight += localHeight + 7;
        }
        if (clicked > -1) {
            ((OnClickFunction)this.itemList.get(clicked).getSecond()).call();
        }
    }

    static int getTotalHeight(@Nonnull Minecraft instance, int width, @Nonnull List<Pair<Component, OnClickFunction>> list) {
        int totalHeight = 0;
        for (int i = 0; i < list.size(); ++i) {
            totalHeight += instance.f_91062_.m_239133_((FormattedText)list.get(i).getFirst(), width - 12) + 7;
        }
        return totalHeight;
    }
}

