/*
 * Decompiled with CFR 0.152.
 */
package com.scarasol.pillagers_gun.event;

import com.scarasol.pillagers_gun.compat.tacz.TaczCompat;
import com.scarasol.pillagers_gun.compat.tacz.TaczGunAttackGoal;
import com.scarasol.pillagers_gun.compat.zombiekit.MobUseFlameThrower;
import com.scarasol.pillagers_gun.config.CommonConfig;
import com.scarasol.pillagers_gun.entity.goal.GunAttackGoal;
import com.scarasol.pillagers_gun.init.PillagersGunItems;
import com.scarasol.pillagers_gun.item.gun.GunItem;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.event.entity.living.LivingKnockBackEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.maven.artifact.versioning.ArtifactVersion;

@Mod.EventBusSubscriber
public class EventHandler {
    public static final UUID ATTRIBUTE_MODIFIER_UUID = UUID.fromString("6D4802D7-3BA3-EEB9-C88A-94AD48F68BFD");
    public static final TagKey<EntityType<?>> PILLAGER_GUNNER = TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)new ResourceLocation("forge:pillager_gunner"));

    @SubscribeEvent
    public static void onEntityJoin(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        Random random = new Random();
        if (entity == null) {
            return;
        }
        if (entity.m_6095_().m_204039_(PILLAGER_GUNNER) && entity instanceof Mob) {
            String id;
            Mob mob = (Mob)entity;
            mob.f_21345_.m_25352_(1, new GunAttackGoal<Mob>(mob, 1.0, 64.0f));
            if (ModList.get().isLoaded("tacz") && ((Boolean)CommonConfig.TACZ_GUN_USE.get()).booleanValue()) {
                mob.f_21345_.m_25352_(1, new TaczGunAttackGoal<Mob>(mob, 1.0));
            }
            mob.m_21559_(false);
            if (!(event.loadedFromDisk() || (id = ForgeRegistries.ENTITY_TYPES.getKey((Object)mob.m_6095_()).toString()).contains("recruits") || id.contains("guardvillagers"))) {
                AttributeInstance attributeInstance;
                if (!(!mob.m_21120_(InteractionHand.MAIN_HAND).m_150930_(Items.f_42717_) || !(random.nextDouble() <= (Double)CommonConfig.EQUIP_CHANCE.get()) || ModList.get().isLoaded("tacz") && ((Boolean)CommonConfig.TACZ_GUN_USE.get()).booleanValue() && ((Boolean)CommonConfig.TACZ_GUN_SPAWN.get()).booleanValue() && TaczCompat.spawnWithTaczGun(mob))) {
                    double totalWeights = (Double)CommonConfig.ASSAULT_CHANCE.get() + (Double)CommonConfig.PISTOL_CHANCE.get() + (Double)CommonConfig.SHOTGUN_CHANCE.get() + (Double)CommonConfig.SNIPERS_RIFLE_CHANCE.get() + (Double)CommonConfig.BAZOOKA_CHANCE.get();
                    double i = random.nextDouble();
                    mob.m_21409_(EquipmentSlot.MAINHAND, ((Double)CommonConfig.DROP_CHANCE.get()).floatValue());
                    boolean flag = false;
                    Optional optional = ModList.get().getModContainerById("zombiekit");
                    if (optional.isPresent()) {
                        ModContainer modContainer = (ModContainer)optional.get();
                        ArtifactVersion version = modContainer.getModInfo().getVersion();
                        boolean bl = flag = version.getMajorVersion() >= 2 && version.getMinorVersion() >= 1;
                    }
                    if (flag) {
                        totalWeights += ((Double)CommonConfig.FLAMETHROWER_CHANCE.get()).doubleValue();
                        if (i < (Double)CommonConfig.FLAMETHROWER_CHANCE.get() / totalWeights) {
                            MobUseFlameThrower.makeMobsUseFlameThrower((LivingEntity)mob);
                            return;
                        }
                        totalWeights -= ((Double)CommonConfig.FLAMETHROWER_CHANCE.get()).doubleValue();
                    }
                    ItemStack itemStack = i < (Double)CommonConfig.PISTOL_CHANCE.get() / totalWeights ? new ItemStack((ItemLike)PillagersGunItems.PISTOL.get()) : (i < ((Double)CommonConfig.PISTOL_CHANCE.get() + (Double)CommonConfig.ASSAULT_CHANCE.get()) / totalWeights ? new ItemStack((ItemLike)PillagersGunItems.ASSAULT_RIFLE.get()) : (i < ((Double)CommonConfig.PISTOL_CHANCE.get() + (Double)CommonConfig.ASSAULT_CHANCE.get() + (Double)CommonConfig.SHOTGUN_CHANCE.get()) / totalWeights ? new ItemStack((ItemLike)PillagersGunItems.SHOTGUN.get()) : (i < ((Double)CommonConfig.PISTOL_CHANCE.get() + (Double)CommonConfig.ASSAULT_CHANCE.get() + (Double)CommonConfig.SHOTGUN_CHANCE.get() + (Double)CommonConfig.SNIPERS_RIFLE_CHANCE.get()) / totalWeights ? new ItemStack((ItemLike)PillagersGunItems.SNIPERS_RIFLE.get()) : new ItemStack((ItemLike)PillagersGunItems.BAZOOKA.get()))));
                    GunItem.init(itemStack);
                    itemStack.m_41764_(1);
                    mob.m_21008_(InteractionHand.MAIN_HAND, itemStack);
                }
                if (mob.m_21205_().m_150930_((Item)PillagersGunItems.SNIPERS_RIFLE.get()) && (attributeInstance = mob.m_21204_().m_22146_(Attributes.f_22277_)) != null) {
                    AttributeModifier attributeModifier = new AttributeModifier(ATTRIBUTE_MODIFIER_UUID, "sniper", (double)((Integer)CommonConfig.SNIPERS_RIFLE_BONUS.get()).intValue(), AttributeModifier.Operation.MULTIPLY_BASE);
                    attributeInstance.m_22120_(ATTRIBUTE_MODIFIER_UUID);
                    attributeInstance.m_22125_(attributeModifier);
                }
            }
        }
    }

    @SubscribeEvent
    public static void changeEquip(LivingEquipmentChangeEvent event) {
        LivingEntity mob = event.getEntity();
        if (mob.m_6095_().m_204039_(PILLAGER_GUNNER) && event.getSlot() == EquipmentSlot.MAINHAND) {
            if (event.getTo().m_150930_((Item)PillagersGunItems.SNIPERS_RIFLE.get())) {
                AttributeInstance attributeInstance = mob.m_21204_().m_22146_(Attributes.f_22277_);
                if (attributeInstance != null) {
                    AttributeModifier attributeModifier = new AttributeModifier(ATTRIBUTE_MODIFIER_UUID, "sniper", (double)((Integer)CommonConfig.SNIPERS_RIFLE_BONUS.get()).intValue(), AttributeModifier.Operation.MULTIPLY_BASE);
                    attributeInstance.m_22120_(ATTRIBUTE_MODIFIER_UUID);
                    attributeInstance.m_22125_(attributeModifier);
                }
            } else if (((Boolean)CommonConfig.TACZ_GUN_USE.get()).booleanValue() && "tacz".equals(ForgeRegistries.ITEMS.getKey((Object)event.getTo().m_41720_()).m_135827_())) {
                TaczCompat.changeEquipmentTo(event);
            } else {
                AttributeInstance attributeInstance = mob.m_21204_().m_22146_(Attributes.f_22277_);
                if (attributeInstance != null) {
                    attributeInstance.m_22120_(ATTRIBUTE_MODIFIER_UUID);
                }
            }
        }
    }

    @SubscribeEvent
    public static void knockbackCancel(LivingKnockBackEvent event) {
        if (event.getEntity().getPersistentData().m_128471_("ShootByGun")) {
            event.setCanceled(true);
        }
    }
}

