/*
 * Decompiled with CFR 0.152.
 */
package org.admany.apocalypticarsenal;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@Mod(value="apocalypticarsenal")
public class ApocalypticArsenal {
    public static final String MOD_ID = "apocalypticarsenal";
    private static final String ADDON_FOLDER_NAME = "ChaosCraft's Apocalyptic Arsenal";

    public ApocalypticArsenal() {
        ApocalypticArsenal.deployTacZAddon();
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        bus.addListener(this::commonSetup);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
    }

    private static void deployTacZAddon() {
        Path gameDir = Paths.get("", new String[0]);
        Path taczDir = gameDir.resolve("tacz");
        Path targetAddonDir = taczDir.resolve(ADDON_FOLDER_NAME);
        try {
            URI uri;
            if (Files.notExists(taczDir, new LinkOption[0])) {
                Files.createDirectories(taczDir, new FileAttribute[0]);
            }
            if (Files.exists(targetAddonDir, new LinkOption[0])) {
                System.out.println("[apocalypticarsenal] TacZ addon folder already present; skipping deployment.");
                return;
            }
            String resourcePath = "/ChaosCraft's Apocalyptic Arsenal";
            URL url = ApocalypticArsenal.class.getResource(resourcePath);
            if (url == null) {
                System.err.println("[apocalypticarsenal] Could not find resource folder 'ChaosCraft's Apocalyptic Arsenal' inside the mod jar.");
                return;
            }
            try {
                uri = url.toURI();
            }
            catch (URISyntaxException e) {
                System.err.println("[apocalypticarsenal] Invalid URI for resource folder: " + e.getMessage());
                return;
            }
            if ("jar".equalsIgnoreCase(uri.getScheme())) {
                try (FileSystem fs = FileSystems.newFileSystem(uri, Map.of());){
                    Path jarPath = fs.getPath(resourcePath, new String[0]);
                    ApocalypticArsenal.copyDirectory(jarPath, targetAddonDir);
                }
            } else {
                Path sourcePath = Paths.get(uri);
                ApocalypticArsenal.copyDirectory(sourcePath, targetAddonDir);
            }
            System.out.println("[apocalypticarsenal] Deployed TacZ addon folder to " + String.valueOf(targetAddonDir.toAbsolutePath()));
        }
        catch (IOException e) {
            System.err.println("[apocalypticarsenal] Failed to deploy TacZ addon folder: " + e.getMessage());
        }
    }

    private static void copyDirectory(Path source, Path target) throws IOException {
        if (Files.notExists(source, new LinkOption[0])) {
            throw new IOException("Source addon folder not found in jar: " + String.valueOf(source));
        }
        Files.walk(source, new FileVisitOption[0]).forEach(path -> {
            block11: {
                try {
                    Path relative = source.relativize((Path)path);
                    Path dest = target.resolve(relative.toString());
                    if (Files.isDirectory(path, new LinkOption[0])) {
                        if (Files.notExists(dest, new LinkOption[0])) {
                            Files.createDirectories(dest, new FileAttribute[0]);
                        }
                        break block11;
                    }
                    if (Files.notExists(dest.getParent(), new LinkOption[0])) {
                        Files.createDirectories(dest.getParent(), new FileAttribute[0]);
                    }
                    try (InputStream in = Files.newInputStream(path, new OpenOption[0]);){
                        Files.copy(in, dest, StandardCopyOption.REPLACE_EXISTING);
                    }
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
            }
        });
    }
}

