/*
 * Decompiled with CFR 0.152.
 */
package tallestegg.guardvillagers.client.models;

import net.minecraft.client.model.AnimationUtils;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.UseAnim;
import tallestegg.guardvillagers.entities.Guard;

public class GuardSteveModel
extends PlayerModel<Guard> {
    public GuardSteveModel(ModelPart part) {
        super(part, false);
    }

    public void setupAnim(Guard entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netbipedHeadYaw, float bipedHeadPitch) {
        super.m_6973_((LivingEntity)entityIn, limbSwing, limbSwingAmount, ageInTicks, netbipedHeadYaw, bipedHeadPitch);
        if (entityIn.getKickTicks() > 0) {
            float f1 = 1.0f - (float)Mth.m_14040_((int)(10 - 2 * entityIn.getKickTicks())) / 10.0f;
            this.f_102813_.f_104203_ = Mth.m_14179_((float)f1, (float)this.f_102813_.f_104203_, (float)-1.4f);
        }
        ItemStack itemstack = entityIn.m_21120_(InteractionHand.MAIN_HAND);
        boolean isHoldingShootable = itemstack.m_41720_() instanceof ProjectileWeaponItem;
        double speed = 0.005;
        if (this.f_102608_ == 0.0f && entityIn.m_5912_() && !isHoldingShootable && entityIn.m_20184_().m_165925_() > speed && !entityIn.m_21205_().m_41619_() && !entityIn.m_21254_()) {
            AnimationUtils.m_102091_((ModelPart)this.f_102811_, (ModelPart)this.f_102812_, (Mob)entityIn, (float)this.f_102608_, (float)ageInTicks);
        }
        if (entityIn.m_5737_() == HumanoidArm.RIGHT) {
            this.eatingAnimationRightHand(InteractionHand.MAIN_HAND, entityIn, ageInTicks);
            this.eatingAnimationLeftHand(InteractionHand.OFF_HAND, entityIn, ageInTicks);
        } else {
            this.eatingAnimationRightHand(InteractionHand.OFF_HAND, entityIn, ageInTicks);
            this.eatingAnimationLeftHand(InteractionHand.MAIN_HAND, entityIn, ageInTicks);
        }
    }

    public static LayerDefinition createMesh() {
        MeshDefinition meshdefinition = PlayerModel.m_170825_((CubeDeformation)CubeDeformation.f_171458_, (boolean)false);
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void eatingAnimationRightHand(InteractionHand hand, Guard entity, float ageInTicks) {
        boolean drinkingoreating;
        ItemStack itemstack = entity.m_21120_(hand);
        boolean bl = drinkingoreating = itemstack.m_41780_() == UseAnim.EAT || itemstack.m_41780_() == UseAnim.DRINK;
        if (entity.isEating() && drinkingoreating) {
            this.f_102811_.f_104204_ = -0.5f;
            this.f_102811_.f_104203_ = -1.3f;
            this.f_102811_.f_104205_ = Mth.m_14089_((float)ageInTicks) * 0.1f;
            this.f_102808_.f_104203_ = Mth.m_14089_((float)ageInTicks) * 0.2f;
            this.f_102808_.f_104204_ = 0.0f;
            this.f_102809_.m_104315_(this.f_102808_);
        }
    }

    public void eatingAnimationLeftHand(InteractionHand hand, Guard entity, float ageInTicks) {
        boolean drinkingoreating;
        ItemStack itemstack = entity.m_21120_(hand);
        boolean bl = drinkingoreating = itemstack.m_41780_() == UseAnim.EAT || itemstack.m_41780_() == UseAnim.DRINK;
        if (entity.isEating() && drinkingoreating) {
            this.f_102812_.f_104204_ = 0.5f;
            this.f_102812_.f_104203_ = -1.3f;
            this.f_102812_.f_104205_ = Mth.m_14089_((float)ageInTicks) * 0.1f;
            this.f_102808_.f_104203_ = Mth.m_14089_((float)ageInTicks) * 0.2f;
            this.f_102808_.f_104204_ = 0.0f;
            this.f_102809_.m_104315_(this.f_102808_);
        }
    }
}

