/*
 * Decompiled with CFR 0.152.
 */
package me.xjqsh.lrtactical.api.collision;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.util.List;
import me.xjqsh.lrtactical.api.collision.ConeFilter;
import me.xjqsh.lrtactical.api.collision.OBBFilter;
import me.xjqsh.lrtactical.api.collision.RayFilter;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

@FunctionalInterface
public interface ITargetFilter {
    @NotNull
    public List<Entity> filterTargets(LivingEntity var1, Vec3 var2, Vec3 var3);

    default public double getMaxRange() {
        return 2.5;
    }

    public static boolean hasLineOfSight(LivingEntity attacker, Entity pEntity) {
        if (pEntity.m_9236_() == attacker.m_9236_()) {
            Vec3 vec3 = new Vec3(attacker.m_20185_(), attacker.m_20188_(), attacker.m_20189_());
            if (ITargetFilter.clip(attacker, new Vec3(pEntity.m_20185_(), pEntity.m_20188_(), pEntity.m_20189_()), vec3)) {
                return true;
            }
            AABB boundingBox = pEntity.m_20191_();
            for (double x : new double[]{boundingBox.f_82288_, boundingBox.f_82291_}) {
                for (double y : new double[]{boundingBox.f_82289_, boundingBox.f_82292_}) {
                    for (double z : new double[]{boundingBox.f_82290_, boundingBox.f_82293_}) {
                        if (!ITargetFilter.clip(attacker, new Vec3(x, y, z), vec3)) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public static boolean clip(LivingEntity attacker, Vec3 vec31, Vec3 vec3) {
        if (vec31.m_82554_(vec3) > 128.0) {
            return false;
        }
        return attacker.m_9236_().m_45547_(new ClipContext(vec3, vec31, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)attacker)).m_6662_() == HitResult.Type.MISS;
    }

    public static class Deserializer
    implements JsonDeserializer<ITargetFilter> {
        public ITargetFilter deserialize(JsonElement element, Type type, JsonDeserializationContext ctx) throws JsonParseException {
            String typeName;
            if (!element.isJsonObject()) {
                throw new JsonParseException("Expected a JsonObject, get " + element);
            }
            JsonObject jsonObject = (JsonObject)element;
            return switch (typeName = GsonHelper.m_13906_((JsonObject)jsonObject, (String)"type")) {
                case "cone" -> (ITargetFilter)ctx.deserialize((JsonElement)jsonObject, ConeFilter.class);
                case "ray" -> (ITargetFilter)ctx.deserialize((JsonElement)jsonObject, RayFilter.class);
                case "obb" -> (ITargetFilter)ctx.deserialize((JsonElement)jsonObject, OBBFilter.class);
                default -> throw new JsonParseException("Unknown filter type: " + typeName);
            };
        }
    }
}

