/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.gui.menu;

import com.simibubi.create.foundation.utility.IInteractionChecker;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public abstract class MenuBase<T>
extends AbstractContainerMenu {
    public Player player;
    public Inventory playerInventory;
    public T contentHolder;

    protected MenuBase(MenuType<?> type, int id, Inventory inv, FriendlyByteBuf extraData) {
        super(type, id);
        this.init(inv, this.createOnClient(extraData));
    }

    protected MenuBase(MenuType<?> type, int id, Inventory inv, T contentHolder) {
        super(type, id);
        this.init(inv, contentHolder);
    }

    protected void init(Inventory inv, T contentHolderIn) {
        this.player = inv.f_35978_;
        this.playerInventory = inv;
        this.contentHolder = contentHolderIn;
        this.initAndReadInventory(this.contentHolder);
        this.addSlots();
        this.m_38946_();
    }

    @OnlyIn(value=Dist.CLIENT)
    protected abstract T createOnClient(FriendlyByteBuf var1);

    protected abstract void initAndReadInventory(T var1);

    protected abstract void addSlots();

    protected abstract void saveData(T var1);

    protected void addPlayerSlots(int x, int y) {
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.m_38897_(this.createPlayerSlot(this.playerInventory, col + row * 9 + 9, x + col * 18, y + row * 18));
            }
        }
        for (int hotbarSlot = 0; hotbarSlot < 9; ++hotbarSlot) {
            this.m_38897_(this.createPlayerSlot(this.playerInventory, hotbarSlot, x + hotbarSlot * 18, y + 58));
        }
    }

    protected Slot createPlayerSlot(Inventory inventory, int index, int x, int y) {
        return new Slot((Container)inventory, index, x, y);
    }

    public void m_6877_(Player playerIn) {
        super.m_6877_(playerIn);
        this.saveData(this.contentHolder);
    }

    public boolean m_6875_(Player player) {
        if (this.contentHolder == null) {
            return false;
        }
        if (this.contentHolder instanceof IInteractionChecker) {
            return ((IInteractionChecker)this.contentHolder).canPlayerUse(player);
        }
        return true;
    }
}

