/*
 * Decompiled with CFR 0.152.
 */
package net.averageanime.createmetalwork.fluid.compat;

import com.mojang.blaze3d.shaders.FogShape;
import com.mojang.blaze3d.systems.RenderSystem;
import com.simibubi.create.foundation.damageTypes.DamageTypeBuilder;
import com.tterrag.registrate.builders.FluidBuilder;
import com.tterrag.registrate.util.entry.FluidEntry;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.averageanime.createmetalwork.CreateMetalwork;
import net.createmod.catnip.theme.Color;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageEffects;
import net.minecraft.world.damagesource.DamageScaling;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.fluids.ForgeFlowingFluid;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;

public class CreatingSpaceFluids {
    public static final FluidEntry<ForgeFlowingFluid.Flowing> MOLTEN_COPRONICKEL = CreateMetalwork.REGISTRATE.standardFluid("molten_copronickel", SolidRenderedPlaceableFluidType.create(16283520, () -> Float.valueOf(0.020833334f))).lang("Molten Copronickel").properties(b -> b.lightLevel(15).density(3000).viscosity(6000).temperature(1300).canSwim(false)).fluidProperties(p -> p.levelDecreasePerBlock(2).tickRate(25).slopeFindDistance(4).explosionResistance(100.0f)).register();
    public static final FluidEntry<ForgeFlowingFluid.Flowing> MOLTEN_HASTELLOY = CreateMetalwork.REGISTRATE.standardFluid("molten_hastelloy", SolidRenderedPlaceableFluidType.create(9541832, () -> Float.valueOf(0.020833334f))).lang("Molten Hastelloy").properties(b -> b.lightLevel(15).density(3000).viscosity(6000).temperature(1300).canSwim(false)).fluidProperties(p -> p.levelDecreasePerBlock(2).tickRate(25).slopeFindDistance(4).explosionResistance(100.0f)).register();
    public static final FluidEntry<ForgeFlowingFluid.Flowing> MOLTEN_INCONEL = CreateMetalwork.REGISTRATE.standardFluid("molten_inconel", SolidRenderedPlaceableFluidType.create(8489606, () -> Float.valueOf(0.020833334f))).lang("Molten Inconel").properties(b -> b.lightLevel(15).density(3000).viscosity(6000).temperature(1300).canSwim(false)).fluidProperties(p -> p.levelDecreasePerBlock(2).tickRate(25).slopeFindDistance(4).explosionResistance(100.0f)).register();
    public static final FluidEntry<ForgeFlowingFluid.Flowing> MOLTEN_MONEL = CreateMetalwork.REGISTRATE.standardFluid("molten_monel", SolidRenderedPlaceableFluidType.create(13811347, () -> Float.valueOf(0.020833334f))).lang("Molten Monel").properties(b -> b.lightLevel(15).density(3000).viscosity(6000).temperature(1300).canSwim(false)).fluidProperties(p -> p.levelDecreasePerBlock(2).tickRate(25).slopeFindDistance(4).explosionResistance(100.0f)).register();
    public static final FluidEntry<ForgeFlowingFluid.Flowing> MOLTEN_REINFORCED_COPPER = CreateMetalwork.REGISTRATE.standardFluid("molten_reinforced_copper", SolidRenderedPlaceableFluidType.create(14196645, () -> Float.valueOf(0.020833334f))).lang("Molten Reinforced Copper").properties(b -> b.lightLevel(15).density(3000).viscosity(6000).temperature(1300).canSwim(false)).fluidProperties(p -> p.levelDecreasePerBlock(2).tickRate(25).slopeFindDistance(4).explosionResistance(100.0f)).register();

    public static void register() {
    }

    private static class SolidRenderedPlaceableFluidType
    extends TintedFluidType {
        private Vector3f fogColor;
        private Supplier<Float> fogDistance;

        public static FluidBuilder.FluidTypeFactory create(int fogColor, Supplier<Float> fogDistance) {
            return (p, s, f) -> {
                SolidRenderedPlaceableFluidType fluidType = new SolidRenderedPlaceableFluidType(p, s, f);
                fluidType.fogColor = new Color(fogColor, false).asVectorF();
                fluidType.fogDistance = fogDistance;
                return fluidType;
            };
        }

        private SolidRenderedPlaceableFluidType(FluidType.Properties properties, ResourceLocation stillTexture, ResourceLocation flowingTexture) {
            super(properties, stillTexture, flowingTexture);
        }

        @Override
        protected int getTintColor(FluidStack stack) {
            return -1;
        }

        @Override
        public int getTintColor(FluidState state, BlockAndTintGetter world, BlockPos pos) {
            return 0xFFFFFF;
        }

        @Override
        protected Vector3f getCustomFogColor() {
            return this.fogColor;
        }

        @Override
        protected float getFogDistanceModifier() {
            return this.fogDistance.get().floatValue();
        }
    }

    public static abstract class TintedFluidType
    extends FluidType {
        protected static final int NO_TINT = -1;
        private ResourceLocation stillTexture;
        private ResourceLocation flowingTexture;
        public static final ResourceKey<DamageType> MOLTEN_FLUID = TintedFluidType.key("molten_fluid");

        public TintedFluidType(FluidType.Properties properties, ResourceLocation stillTexture, ResourceLocation flowingTexture) {
            super(properties);
            this.stillTexture = stillTexture;
            this.flowingTexture = flowingTexture;
        }

        private static ResourceKey<DamageType> key(String name) {
            return ResourceKey.m_135785_((ResourceKey)Registries.f_268580_, (ResourceLocation)CreateMetalwork.genRL(name));
        }

        public static void bootstrap(BootstapContext<DamageType> ctx) {
            new DamageTypeBuilder(MOLTEN_FLUID).scaling(DamageScaling.ALWAYS).effects(DamageEffects.BURNING).register(ctx);
        }

        private static DamageSource source(ResourceKey<DamageType> key, LevelReader level) {
            Registry registry = level.m_9598_().m_175515_(Registries.f_268580_);
            return new DamageSource((Holder)registry.m_246971_(key));
        }

        public static DamageSource moltenFluid(Level level) {
            return TintedFluidType.source(MOLTEN_FLUID, (LevelReader)level);
        }

        public boolean move(FluidState state, LivingEntity entity, Vec3 movementVector, double gravity) {
            entity.m_20256_(entity.m_20184_().m_82490_(0.6));
            entity.m_6469_(TintedFluidType.moltenFluid(entity.m_9236_()), 4.0f);
            entity.m_20254_(15);
            return false;
        }

        public void initializeClient(Consumer<IClientFluidTypeExtensions> consumer) {
            consumer.accept(new IClientFluidTypeExtensions(){

                public ResourceLocation getStillTexture() {
                    return stillTexture;
                }

                public ResourceLocation getFlowingTexture() {
                    return flowingTexture;
                }

                public int getTintColor(FluidStack stack) {
                    return this.getTintColor(stack);
                }

                public int getTintColor(FluidState state, BlockAndTintGetter getter, BlockPos pos) {
                    return this.getTintColor(state, getter, pos);
                }

                @NotNull
                public Vector3f modifyFogColor(Camera camera, float partialTick, ClientLevel level, int renderDistance, float darkenWorldAmount, Vector3f fluidFogColor) {
                    Vector3f customFogColor = this.getCustomFogColor();
                    return customFogColor == null ? fluidFogColor : customFogColor;
                }

                public void modifyFogRender(Camera camera, FogRenderer.FogMode mode, float renderDistance, float partialTick, float nearDistance, float farDistance, FogShape shape) {
                    float modifier = this.getFogDistanceModifier();
                    float baseWaterFog = 96.0f;
                    if (modifier != 1.0f) {
                        RenderSystem.setShaderFogShape((FogShape)FogShape.CYLINDER);
                        RenderSystem.setShaderFogStart((float)-8.0f);
                        RenderSystem.setShaderFogEnd((float)(baseWaterFog * modifier));
                    }
                }
            });
        }

        protected abstract int getTintColor(FluidStack var1);

        protected abstract int getTintColor(FluidState var1, BlockAndTintGetter var2, BlockPos var3);

        protected Vector3f getCustomFogColor() {
            return null;
        }

        protected float getFogDistanceModifier() {
            return 1.0f;
        }
    }
}

