/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.snatched.network;

import java.util.function.Supplier;
import net.mcreator.snatched.SnatchedMod;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class SnatchedModVariables {
    public static final Capability<PlayerVariables> PLAYER_VARIABLES_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<PlayerVariables>(){});

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        SnatchedMod.addNetworkMessage(PlayerVariablesSyncMessage.class, PlayerVariablesSyncMessage::buffer, PlayerVariablesSyncMessage::new, PlayerVariablesSyncMessage::handler);
    }

    @SubscribeEvent
    public static void init(RegisterCapabilitiesEvent event) {
        event.register(PlayerVariables.class);
    }

    public static class PlayerVariablesSyncMessage {
        private final PlayerVariables data;

        public PlayerVariablesSyncMessage(FriendlyByteBuf buffer) {
            this.data = new PlayerVariables();
            this.data.readNBT((Tag)buffer.m_130260_());
        }

        public PlayerVariablesSyncMessage(PlayerVariables data) {
            this.data = data;
        }

        public static void buffer(PlayerVariablesSyncMessage message, FriendlyByteBuf buffer) {
            buffer.m_130079_((CompoundTag)message.data.writeNBT());
        }

        public static void handler(PlayerVariablesSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer()) {
                    PlayerVariables variables = (PlayerVariables)Minecraft.m_91087_().f_91074_.getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
                    variables.roping_process = message.data.roping_process;
                    variables.roping_escape = message.data.roping_escape;
                    variables.b = message.data.b;
                    variables.sound_cooldown = message.data.sound_cooldown;
                    variables.bagging_process = message.data.bagging_process;
                    variables.bagging_escape = message.data.bagging_escape;
                    variables.searching = message.data.searching;
                    variables.dismount = message.data.dismount;
                    variables.time_rope = message.data.time_rope;
                    variables.follow = message.data.follow;
                    variables.followed = message.data.followed;
                    variables.entity_car = message.data.entity_car;
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class PlayerVariables {
        public double roping_process = 0.0;
        public double roping_escape = 0.0;
        public double b = 0.0;
        public double sound_cooldown = 0.0;
        public double bagging_process = 0.0;
        public double bagging_escape = 0.0;
        public double searching = 0.0;
        public double dismount = 0.0;
        public double time_rope = 50.0;
        public boolean follow = false;
        public boolean followed = false;
        public String entity_car = "\"\"";

        public void syncPlayerVariables(Entity entity) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                SnatchedMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new PlayerVariablesSyncMessage(this));
            }
        }

        public Tag writeNBT() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128347_("roping_process", this.roping_process);
            nbt.m_128347_("roping_escape", this.roping_escape);
            nbt.m_128347_("b", this.b);
            nbt.m_128347_("sound_cooldown", this.sound_cooldown);
            nbt.m_128347_("bagging_process", this.bagging_process);
            nbt.m_128347_("bagging_escape", this.bagging_escape);
            nbt.m_128347_("searching", this.searching);
            nbt.m_128347_("dismount", this.dismount);
            nbt.m_128347_("time_rope", this.time_rope);
            nbt.m_128379_("follow", this.follow);
            nbt.m_128379_("followed", this.followed);
            nbt.m_128359_("entity_car", this.entity_car);
            return nbt;
        }

        public void readNBT(Tag tag) {
            CompoundTag nbt = (CompoundTag)tag;
            this.roping_process = nbt.m_128459_("roping_process");
            this.roping_escape = nbt.m_128459_("roping_escape");
            this.b = nbt.m_128459_("b");
            this.sound_cooldown = nbt.m_128459_("sound_cooldown");
            this.bagging_process = nbt.m_128459_("bagging_process");
            this.bagging_escape = nbt.m_128459_("bagging_escape");
            this.searching = nbt.m_128459_("searching");
            this.dismount = nbt.m_128459_("dismount");
            this.time_rope = nbt.m_128459_("time_rope");
            this.follow = nbt.m_128471_("follow");
            this.followed = nbt.m_128471_("followed");
            this.entity_car = nbt.m_128461_("entity_car");
        }
    }

    @Mod.EventBusSubscriber
    private static class PlayerVariablesProvider
    implements ICapabilitySerializable<Tag> {
        private final PlayerVariables playerVariables = new PlayerVariables();
        private final LazyOptional<PlayerVariables> instance = LazyOptional.of(() -> this.playerVariables);

        private PlayerVariablesProvider() {
        }

        @SubscribeEvent
        public static void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
            if (event.getObject() instanceof Player && !(event.getObject() instanceof FakePlayer)) {
                event.addCapability(new ResourceLocation("snatched", "player_variables"), (ICapabilityProvider)new PlayerVariablesProvider());
            }
        }

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            return cap == PLAYER_VARIABLES_CAPABILITY ? this.instance.cast() : LazyOptional.empty();
        }

        public Tag serializeNBT() {
            return this.playerVariables.writeNBT();
        }

        public void deserializeNBT(Tag nbt) {
            this.playerVariables.readNBT(nbt);
        }
    }

    @Mod.EventBusSubscriber
    public static class EventBusVariableHandlers {
        @SubscribeEvent
        public static void onPlayerLoggedInSyncPlayerVariables(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerRespawnedSyncPlayerVariables(PlayerEvent.PlayerRespawnEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimensionSyncPlayerVariables(PlayerEvent.PlayerChangedDimensionEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void clonePlayer(PlayerEvent.Clone event) {
            event.getOriginal().revive();
            PlayerVariables original = (PlayerVariables)event.getOriginal().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            PlayerVariables clone = (PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            clone.time_rope = original.time_rope;
            if (!event.isWasDeath()) {
                clone.roping_process = original.roping_process;
                clone.roping_escape = original.roping_escape;
                clone.b = original.b;
                clone.sound_cooldown = original.sound_cooldown;
                clone.bagging_process = original.bagging_process;
                clone.bagging_escape = original.bagging_escape;
                clone.searching = original.searching;
                clone.dismount = original.dismount;
                clone.follow = original.follow;
                clone.followed = original.followed;
                clone.entity_car = original.entity_car;
            }
        }
    }
}

