/*
 * Decompiled with CFR 0.152.
 */
package org.antarcticgardens.newage.content.electricity.network;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.util.Tuple;
import org.antarcticgardens.newage.content.electricity.connector.ElectricalConnectorBlockEntity;
import org.antarcticgardens.newage.content.electricity.network.NetworkPath;
import org.antarcticgardens.newage.content.electricity.network.NetworkPathKey;

public class NetworkPathConductivityContext {
    private final Map<NetworkPathKey<ElectricalConnectorBlockEntity>, Tuple<Long, Long>> connections = new HashMap<NetworkPathKey<ElectricalConnectorBlockEntity>, Tuple<Long, Long>>();

    public NetworkPathConductivityContext() {
    }

    public NetworkPathConductivityContext(NetworkPathConductivityContext context) {
        for (Map.Entry<NetworkPathKey<ElectricalConnectorBlockEntity>, Tuple<Long, Long>> e : context.connections.entrySet()) {
            this.connections.put(e.getKey(), (Tuple<Long, Long>)new Tuple((Object)((Long)e.getValue().m_14418_()), (Object)((Long)e.getValue().m_14419_())));
        }
    }

    public void addConnection(ElectricalConnectorBlockEntity node, ElectricalConnectorBlockEntity node1) {
        if (!((Object)((Object)node)).equals((Object)node1) && !this.connections.containsKey(new NetworkPathKey<ElectricalConnectorBlockEntity>(node, node1))) {
            this.connections.put(new NetworkPathKey<ElectricalConnectorBlockEntity>(node, node1), (Tuple<Long, Long>)new Tuple((Object)node.getConnectors().get((Object)node1).getConductivity(), (Object)0L));
        }
    }

    protected long calculatePathConductivity(NetworkPath path) {
        ElectricalConnectorBlockEntity prevNode = null;
        long conductivity = Long.MAX_VALUE;
        for (ElectricalConnectorBlockEntity node : path.getNodes()) {
            if (prevNode == null) {
                prevNode = node;
                continue;
            }
            NetworkPathKey<ElectricalConnectorBlockEntity> key = new NetworkPathKey<ElectricalConnectorBlockEntity>(prevNode, node);
            if (!this.connections.containsKey(key)) {
                return 0L;
            }
            long connectionConductivity = (Long)this.connections.get(key).m_14419_();
            conductivity = Math.min(connectionConductivity, conductivity);
            prevNode = node;
        }
        return conductivity;
    }

    protected void decreasePathConductivity(NetworkPath path, long amount) {
        ElectricalConnectorBlockEntity prevNode = null;
        for (ElectricalConnectorBlockEntity node : path.getNodes()) {
            if (prevNode == null) {
                prevNode = node;
                continue;
            }
            NetworkPathKey<ElectricalConnectorBlockEntity> key = new NetworkPathKey<ElectricalConnectorBlockEntity>(prevNode, node);
            long connectionConductivity = (Long)this.connections.get(key).m_14419_();
            this.connections.get(key).m_145025_((Object)(connectionConductivity - amount));
            prevNode = node;
        }
    }

    protected long getConnectionConductivity(NetworkPathKey<ElectricalConnectorBlockEntity> key) {
        return (Long)this.connections.get(key).m_14419_();
    }

    protected void updateConductivity() {
        for (Map.Entry<NetworkPathKey<ElectricalConnectorBlockEntity>, Tuple<Long, Long>> e : this.connections.entrySet()) {
            this.connections.get(e.getKey()).m_145025_((Object)((Long)e.getValue().m_14418_()));
        }
    }
}

