/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.betterdungeons.world.structure.spider_dungeon.piece;

import com.google.common.collect.Sets;
import com.yungnickyoung.minecraft.yungsapi.api.world.randomize.BlockStateRandomizer;
import java.util.BitSet;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;

public abstract class SpiderDungeonPiece
extends StructurePiece {
    protected static final Set<Block> BLOCK_BLACKLIST = Sets.newHashSet((Object[])new Block[]{Blocks.f_50090_, Blocks.f_50041_, Blocks.f_50085_, Blocks.f_50087_, Blocks.f_50054_, Blocks.f_50052_, Blocks.f_50050_, Blocks.f_50055_, Blocks.f_50053_, Blocks.f_50051_, Blocks.f_50034_, Blocks.f_50359_});

    protected SpiderDungeonPiece(StructurePieceType structurePieceTypeIn, int chainLength, BoundingBox box) {
        super(structurePieceTypeIn, chainLength, box);
    }

    public SpiderDungeonPiece(StructurePieceType structurePierceTypeIn, CompoundTag compoundTag) {
        super(structurePierceTypeIn, compoundTag);
    }

    protected void decorateCave(WorldGenLevel world, RandomSource decoRand, ChunkPos chunkPos, BoundingBox box, BitSet carvingMask) {
        carvingMask.stream().forEach(mask -> {
            if (decoRand.m_188501_() < 0.15f) {
                int globalZ;
                int x = mask & 0xF;
                int z = mask >> 4 & 0xF;
                int globalX = x + chunkPos.f_45578_ * 16;
                int y = (mask >> 8) + world.m_141937_();
                if ((this.m_73398_((BlockGetter)world, globalX - 1, y, globalZ = z + chunkPos.f_45579_ * 16, box).m_60815_() || this.m_73398_((BlockGetter)world, globalX + 1, y, globalZ, box).m_60815_() || this.m_73398_((BlockGetter)world, globalX, y, globalZ - 1, box).m_60815_() || this.m_73398_((BlockGetter)world, globalX, y, globalZ + 1, box).m_60815_() || this.m_73398_((BlockGetter)world, globalX, y - 1, globalZ, box).m_60815_() || this.m_73398_((BlockGetter)world, globalX, y + 1, globalZ, box).m_60815_()) && !BLOCK_BLACKLIST.contains(this.m_73398_((BlockGetter)world, globalX, y, globalZ, box).m_60734_())) {
                    this.m_73434_(world, Blocks.f_50033_.m_49966_(), globalX, y, globalZ, box);
                }
            }
        });
    }

    protected void placeSphereRandomized(WorldGenLevel world, BoundingBox box, BlockPos center, float radius, RandomSource rand, float chance, BlockStateRandomizer blockSelector, boolean replaceOnlyAir) {
        for (float x = -radius; x <= radius; x += 1.0f) {
            for (float z = -radius; z <= radius; z += 1.0f) {
                for (float y = -radius; y <= radius; y += 1.0f) {
                    if (!(x * x + y * y + z * z < radius * radius) || replaceOnlyAir && !this.m_73398_((BlockGetter)world, (int)x + center.m_123341_(), (int)y + center.m_123342_(), (int)z + center.m_123343_(), box).m_60795_() || !(rand.m_188501_() < chance)) continue;
                    this.m_73434_(world, blockSelector.get(rand), (int)x + center.m_123341_(), (int)y + center.m_123342_(), (int)z + center.m_123343_(), box);
                }
            }
        }
    }

    protected void placeSphereRandomized(WorldGenLevel world, BoundingBox box, int centerX, int centerY, int centerZ, float radius, RandomSource rand, float chance, BlockStateRandomizer blockSelector, boolean replaceOnlyAir) {
        this.placeSphereRandomized(world, box, new BlockPos(centerX, centerY, centerZ), radius, rand, chance, blockSelector, replaceOnlyAir);
    }

    protected void setBlockState(WorldGenLevel worldIn, RandomSource random, BlockStateRandomizer selector, int x, int y, int z, BoundingBox boundingboxIn) {
        BlockState blockState = selector.get(random);
        this.m_73434_(worldIn, blockState, x, y, z, boundingboxIn);
    }

    protected static BoundingBox getInitialBoundingBox(BlockPos startPos) {
        return new BoundingBox(startPos).m_191961_(64);
    }
}

