/*
 * Decompiled with CFR 0.152.
 */
package com.corosus.zombieawareness;

import com.corosus.modconfig.ConfigMod;
import com.corosus.modconfig.IConfigCategory;
import com.corosus.zombieawareness.EntityRegistry;
import com.corosus.zombieawareness.EventRegistry;
import com.corosus.zombieawareness.ZAEventHandler;
import com.corosus.zombieawareness.ZAUtil;
import com.corosus.zombieawareness.client.ClientRegistry;
import com.corosus.zombieawareness.client.SoundRegistry;
import com.corosus.zombieawareness.config.MobListsConfig;
import com.corosus.zombieawareness.config.SoundsListsConfig;
import com.corosus.zombieawareness.config.ZAConfigClient;
import com.corosus.zombieawareness.config.ZAConfigFeatures;
import com.corosus.zombieawareness.config.ZAConfigGeneral;
import com.corosus.zombieawareness.config.ZAConfigPlayerLists;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="zombieawareness")
public class ZombieAwareness {
    public static final Logger LOGGER = LogManager.getLogger();
    public static final String MODID = "zombieawareness";

    public ZombieAwareness() {
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        DistExecutor.safeRunForDist(() -> ClientRegistry::new, () -> EventRegistry::new);
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)new EntityRegistry());
        MinecraftForge.EVENT_BUS.register((Object)new ZAEventHandler());
        MinecraftForge.EVENT_BUS.addListener(this::serverStart);
        EntityRegistry.init();
        SoundRegistry.init();
        new File("./config/zombieawareness").mkdirs();
        ConfigMod.addConfigFile((String)MODID, (IConfigCategory)new ZAConfigGeneral());
        ConfigMod.addConfigFile((String)MODID, (IConfigCategory)new ZAConfigClient());
        ConfigMod.addConfigFile((String)MODID, (IConfigCategory)new ZAConfigFeatures());
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)MobListsConfig.CONFIG, MODID + File.separator + "MobLists.toml");
        ConfigMod.addConfigFile((String)MODID, (IConfigCategory)new ZAConfigPlayerLists());
        modBus.addListener(this::onLoad);
    }

    @SubscribeEvent
    public void onLoad(ModConfigEvent.Loading configEvent) {
        if (configEvent.getConfig().getFileName().contains("MobLists.toml")) {
            ZombieAwareness.generateEntityTickList();
        }
        if (configEvent.getConfig().getFileName().contains("SoundLists.toml")) {
            ZombieAwareness.generateSoundList();
        }
    }

    @SubscribeEvent
    public void serverStart(ServerStartingEvent event) {
        ZombieAwareness.clearConfigCache();
    }

    public static void clearConfigCache() {
        ZAUtil.lookupTickableEntitiesCache.clear();
    }

    public static void dbg(Object obj) {
        if (ZAConfigGeneral.debugConsole) {
            System.out.println(obj);
        }
    }

    public static boolean canProcessEntity(Entity ent) {
        if (!ZombieAwareness.canEntityBeProcessedOverride(ent)) {
            return false;
        }
        return ZombieAwareness.canProcessEntity(ent.m_6095_(), false);
    }

    public static boolean canProcessEntity(EntityType ent, boolean pregen) {
        String entName = ZombieAwareness.getEntityRegisteredName(ent);
        if (ZAUtil.lookupTickableEntitiesCache.containsKey(ent)) {
            return ZAUtil.lookupTickableEntitiesCache.get(ent);
        }
        boolean result = false;
        if (ZombieAwareness.canConfigEntity(ent)) {
            boolean canProcess = ZombieAwareness.getDefaultForEntity(ent);
            try {
                if (entName != null && !entName.equals("")) {
                    result = canProcess;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            ZAUtil.lookupTickableEntitiesCache.put(ent, result);
        }
        return result;
    }

    public static boolean canEntityBeProcessedOverride(Entity entity) {
        return true;
    }

    public static boolean canConfigEntity(EntityType ent) {
        return ent.m_20674_() == MobCategory.MONSTER;
    }

    public static boolean getDefaultForEntity(EntityType ent) {
        if (ZombieAwareness.canConfigEntity(ent)) {
            return ((List)MobListsConfig.GENERAL.enhancedMobs.get()).contains(ForgeRegistries.ENTITY_TYPES.getKey((Object)ent).toString());
        }
        return false;
    }

    public static List<String> getListFromCSV(String csv) {
        return Stream.of(csv.split(",")).map(String::trim).collect(Collectors.toList());
    }

    public static String getEntityRegisteredName(EntityType ent) {
        try {
            return ForgeRegistries.ENTITY_TYPES.getKey((Object)ent).toString();
        }
        catch (Exception ex) {
            if (ZAConfigGeneral.debugConsole) {
                ex.printStackTrace();
            }
            return ent.getClass().getSimpleName();
        }
    }

    public static void generateEntityTickList() {
        for (Map.Entry entry : ForgeRegistries.ENTITY_TYPES.getEntries()) {
            boolean tickEnt = ZombieAwareness.canConfigEntity((EntityType)entry.getValue());
            if (!tickEnt) continue;
            MobListsConfig.enhanceableMobsList.add(((ResourceKey)entry.getKey()).m_135782_().toString());
        }
        MobListsConfig.GENERAL.enhanceableMobs.set(MobListsConfig.enhanceableMobsList);
    }

    public static void generateSoundList() {
        for (Map.Entry entry : ForgeRegistries.SOUND_EVENTS.getEntries()) {
            SoundsListsConfig.allSoundsInGameList.add(((ResourceKey)entry.getKey()).m_135782_().toString());
        }
        SoundsListsConfig.GENERAL.allSoundsInGame.set(SoundsListsConfig.allSoundsInGameList);
        System.out.println(SoundsListsConfig.allSoundsInGameList);
        System.out.println("asdasd");
    }
}

