/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.smokestack.particles.chimneypush;

import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.railwayteam.railways.content.smokestack.particles.CustomAnimatedTextureSheetParticle;
import com.railwayteam.railways.content.smokestack.particles.chimneypush.ChimneyPushParticleData;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

@OnlyIn(value=Dist.CLIENT)
public class ChimneyPushParticle
extends CustomAnimatedTextureSheetParticle {
    protected final boolean leadOnly;
    protected final RandomSource random;
    protected final boolean small;

    protected ChimneyPushParticle(ClientLevel level, double x, double y, double z, RandomSource random, boolean leadOnly, boolean small) {
        super(level, x, y, z, 0.0, 0.0, 0.0);
        this.small = small;
        this.f_107215_ = 0.0;
        this.f_107216_ = 0.0;
        this.f_107217_ = 0.0;
        this.f_107663_ = 1.0f;
        this.f_172258_ = 0.99f;
        this.random = random;
        this.leadOnly = leadOnly;
        this.m_107257_((int)((double)random.m_216332_(15, 25) * Math.min(this.getAnimationFactor() * 3.0, 1.0)));
    }

    protected double getAnimationFactor() {
        return this.leadOnly ? (this.small ? 0.3333333333333333 : 0.23076923076923078) : 1.0;
    }

    @Override
    protected int frameHeightFactor() {
        return this.small ? 2 : 1;
    }

    @Override
    protected double getAnimationProgress() {
        int age = Math.min(this.f_107224_, this.f_107225_ - 1);
        double lifeFactor = (double)age / (double)this.f_107225_;
        return Mth.m_14008_((double)lifeFactor, (double)0.0, (double)1.0) * this.getAnimationFactor();
    }

    public void m_5744_(@NotNull VertexConsumer buffer, @NotNull Camera renderInfo, float partialTicks) {
        Quaternionf facing;
        Vec3 vec3 = renderInfo.m_90583_();
        float quadSize = this.m_5902_(partialTicks);
        float x = (float)(Mth.m_14139_((double)partialTicks, (double)this.f_107209_, (double)this.f_107212_) - vec3.m_7096_());
        float y = (float)(Mth.m_14139_((double)partialTicks, (double)this.f_107210_, (double)this.f_107213_) - vec3.m_7098_()) + quadSize / 2.0f;
        float z = (float)(Mth.m_14139_((double)partialTicks, (double)this.f_107211_, (double)this.f_107214_) - vec3.m_7094_());
        if (this.f_107231_ == 0.0f) {
            facing = Axis.f_252436_.m_252977_(-renderInfo.m_90590_());
        } else {
            facing = new Quaternionf((Quaternionfc)Axis.f_252436_.m_252977_(-renderInfo.m_90590_()));
            float i = Mth.m_14179_((float)partialTicks, (float)this.f_107204_, (float)this.f_107231_);
            facing.mul((Quaternionfc)Axis.f_252403_.m_252961_(i));
        }
        Vector3f[] vertices = new Vector3f[]{new Vector3f(-1.0f, -1.0f, 0.0f), new Vector3f(-1.0f, 1.0f, 0.0f), new Vector3f(1.0f, 1.0f, 0.0f), new Vector3f(1.0f, -1.0f, 0.0f)};
        for (int i = 0; i < 4; ++i) {
            Vector3f vertex = vertices[i];
            vertex.rotate((Quaternionfc)facing);
            vertex.mul(quadSize);
            if (this.small) {
                vertex.mul(1.0f, 2.0f, 1.0f);
            }
            vertex.add(x, y, z);
        }
        float u0 = this.m_5970_();
        float u1 = this.m_5952_();
        float v0 = this.m_5951_();
        float v1 = this.m_5950_();
        int packedLight = this.m_6355_(partialTicks);
        buffer.m_5483_((double)vertices[0].x(), (double)vertices[0].y(), (double)vertices[0].z()).m_7421_(u1, v1).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(packedLight).m_5752_();
        buffer.m_5483_((double)vertices[1].x(), (double)vertices[1].y(), (double)vertices[1].z()).m_7421_(u1, v0).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(packedLight).m_5752_();
        buffer.m_5483_((double)vertices[2].x(), (double)vertices[2].y(), (double)vertices[2].z()).m_7421_(u0, v0).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(packedLight).m_5752_();
        buffer.m_5483_((double)vertices[3].x(), (double)vertices[3].y(), (double)vertices[3].z()).m_7421_(u0, v1).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(packedLight).m_5752_();
    }

    public void setOldPos() {
        this.f_107209_ = this.f_107212_;
        this.f_107210_ = this.f_107213_;
        this.f_107211_ = this.f_107214_;
    }

    public void m_5989_() {
        this.setOldPos();
        if (this.f_107224_++ >= this.f_107225_) {
            this.m_107274_();
        }
    }

    @NotNull
    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107430_;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Factory<T extends ChimneyPushParticleData<T>>
    implements ParticleProvider<T> {
        private final SpriteSet spriteSet;

        public Factory(SpriteSet spriteSet) {
            this.spriteSet = spriteSet;
        }

        @Nullable
        public Particle createParticle(@NotNull T type, @NotNull ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            ChimneyPushParticle particle = new ChimneyPushParticle(level, x, y, z, level.m_213780_(), ((ChimneyPushParticleData)type).leadOnly, type instanceof ChimneyPushParticleData.Small);
            int textureCount = 18;
            int idx = 0;
            if (Mth.m_14033_((float)((ChimneyPushParticleData)type).red, (float)-1.0f) && Mth.m_14033_((float)((ChimneyPushParticleData)type).green, (float)-1.0f) && Mth.m_14033_((float)((ChimneyPushParticleData)type).blue, (float)-1.0f)) {
                idx = 1;
            } else if (Mth.m_14033_((float)((ChimneyPushParticleData)type).red, (float)((ChimneyPushParticleData)type).green) && Mth.m_14033_((float)((ChimneyPushParticleData)type).green, (float)((ChimneyPushParticleData)type).blue) && ((ChimneyPushParticleData)type).red < -1.0f && ((ChimneyPushParticleData)type).red >= -17.0f) {
                idx = (int)Math.abs(((ChimneyPushParticleData)type).red);
            }
            particle.m_108337_(this.spriteSet.m_5819_(idx, textureCount - 1));
            particle.f_107224_ = level.m_213780_().m_188503_(5);
            if (idx == 0) {
                particle.f_107227_ = ((ChimneyPushParticleData)type).red;
                particle.f_107228_ = ((ChimneyPushParticleData)type).green;
                particle.f_107229_ = ((ChimneyPushParticleData)type).blue;
            }
            particle.f_107663_ = ((ChimneyPushParticleData)type).getQuadSize();
            return particle;
        }
    }
}

