/*
 * Decompiled with CFR 0.152.
 */
package net.tkg.ChamberClarity.client.event;

import com.tacz.guns.api.TimelessAPI;
import com.tacz.guns.api.item.IGun;
import com.tacz.guns.client.input.InspectKey;
import com.tacz.guns.client.resource.GunDisplayInstance;
import com.tacz.guns.client.resource.pojo.display.gun.AmmoCountStyle;
import com.tacz.guns.resource.index.CommonGunIndex;
import com.tacz.guns.resource.pojo.data.gun.Bolt;
import com.tacz.guns.resource.pojo.data.gun.GunData;
import com.tacz.guns.util.AttachmentDataUtils;
import java.text.DecimalFormat;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.tkg.ChamberClarity.config.ChamberClarityClientConfigs;

@Mod.EventBusSubscriber(modid="chamber_clarity", value={Dist.CLIENT})
public class InspectKeyPress {
    private static final DecimalFormat CURRENT_AMMO_FORMAT_PERCENT = new DecimalFormat("0%");

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            ItemStack mainHandItem;
            Minecraft minecraft = Minecraft.m_91087_();
            LocalPlayer player = minecraft.f_91074_;
            if (player != null && InspectKey.INSPECT_KEY.m_90857_() && (mainHandItem = player.m_21205_()).m_41720_() instanceof IGun) {
                IGun iGun = (IGun)mainHandItem.m_41720_();
                ResourceLocation gunId = iGun.getGunId(mainHandItem);
                CommonGunIndex gunIndex = TimelessAPI.getCommonGunIndex((ResourceLocation)gunId).orElse(null);
                GunDisplayInstance displayInstance = TimelessAPI.getGunDisplay((ItemStack)mainHandItem).orElse(null);
                CompoundTag tag = mainHandItem.m_41783_();
                if (gunIndex != null && tag != null) {
                    MutableComponent ammoText;
                    int barrelBulletAmount = iGun.hasBulletInBarrel(mainHandItem) && gunIndex.getGunData().getBolt() != Bolt.OPEN_BOLT ? 1 : 0;
                    int maxAmmoCount = AttachmentDataUtils.getAmmoCountWithAttachment((ItemStack)mainHandItem, (GunData)gunIndex.getGunData()) + barrelBulletAmount;
                    int currentAmmoCount = iGun.getCurrentAmmoCount(mainHandItem) + barrelBulletAmount;
                    if (((Boolean)ChamberClarityClientConfigs.REALISTIC_AMMO_CHECK.get()).booleanValue()) {
                        float ammoPercentage = (float)currentAmmoCount / (maxAmmoCount == 0 ? 1.0f : (float)maxAmmoCount);
                        ammoText = ammoPercentage == 1.0f ? Component.m_237115_((String)"text.chamber_clarity.full") : (ammoPercentage > 0.75f ? Component.m_237115_((String)"text.chamber_clarity.almost_full") : (ammoPercentage > 0.5f ? Component.m_237115_((String)"text.chamber_clarity.above_half") : (ammoPercentage > 0.25f ? Component.m_237115_((String)"text.chamber_clarity.below_half") : (ammoPercentage > 0.0f ? Component.m_237115_((String)"text.chamber_clarity.almost_empty") : Component.m_237115_((String)"text.chamber_clarity.empty")))));
                    } else if (!iGun.useDummyAmmo(mainHandItem)) {
                        if (displayInstance != null && displayInstance.getAmmoCountStyle() == AmmoCountStyle.PERCENT) {
                            String percentText = CURRENT_AMMO_FORMAT_PERCENT.format((float)currentAmmoCount / (maxAmmoCount == 0 ? 1.0f : (float)maxAmmoCount));
                            ammoText = Component.m_237113_((String)percentText);
                        } else {
                            ammoText = Component.m_237113_((String)"%d/%d".formatted(currentAmmoCount, maxAmmoCount));
                        }
                    } else {
                        int dummyAmmoAmount = iGun.getDummyAmmoAmount(mainHandItem);
                        if (displayInstance != null && displayInstance.getAmmoCountStyle() == AmmoCountStyle.PERCENT) {
                            String percentText = CURRENT_AMMO_FORMAT_PERCENT.format((float)currentAmmoCount / (maxAmmoCount == 0 ? 1.0f : (float)maxAmmoCount));
                            ammoText = Component.m_237113_((String)"%s (%d)".formatted(percentText, dummyAmmoAmount));
                        } else {
                            ammoText = Component.m_237113_((String)"%d/%d (%d)".formatted(currentAmmoCount, maxAmmoCount, dummyAmmoAmount));
                        }
                    }
                    String gunFireMode = tag.m_128461_("GunFireMode");
                    MutableComponent ammoMessage = Component.m_237115_((String)"text.chamber_clarity.ammo").m_7220_((Component)ammoText);
                    MutableComponent modeMessage = Component.m_237115_((String)"text.chamber_clarity.mode").m_7220_((Component)Component.m_237113_((String)gunFireMode));
                    player.m_5661_((Component)ammoMessage.m_130946_(", ").m_7220_((Component)modeMessage), true);
                } else {
                    player.m_5661_((Component)Component.m_237113_((String)"No gun data found!"), true);
                }
            }
        }
    }
}

