/*
 * Decompiled with CFR 0.152.
 */
package ru.liko.suppressionmod;

import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import ru.liko.suppressionmod.Config;
import ru.liko.suppressionmod.client.ClientConfigState;

@OnlyIn(value=Dist.CLIENT)
public class BulletSuppressionHandler {
    private final Random rnd = new Random();
    private int suppressionLevel = 0;
    private int targetLevel = 0;
    private int recentHitCount = 0;
    private int hitCounterTicks = 0;
    private int shockFlashTicks = 0;

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent e) {
        if (e.phase != TickEvent.Phase.END) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (mc == null || mc.m_91104_() || mc.f_91074_ == null || mc.f_91073_ == null) {
            return;
        }
        int maxLevel = ClientConfigState.maxSuppressionLevel();
        int recovery = ClientConfigState.recoveryRate();
        int targetDecay = ClientConfigState.targetDecayRate();
        if (this.suppressionLevel < this.targetLevel) {
            int ramp = Math.max(4, (this.targetLevel - this.suppressionLevel) / 5);
            this.suppressionLevel = Math.min(this.targetLevel, this.suppressionLevel + ramp);
        } else if (this.suppressionLevel > 0) {
            this.suppressionLevel = Math.max(0, this.suppressionLevel - recovery);
        }
        if (this.targetLevel > 0) {
            this.targetLevel = Math.max(0, this.targetLevel - targetDecay);
        }
        if (this.hitCounterTicks > 0) {
            --this.hitCounterTicks;
            if (this.hitCounterTicks == 0) {
                this.recentHitCount = 0;
            }
        }
        if (this.shockFlashTicks > 0) {
            --this.shockFlashTicks;
        }
        if (this.suppressionLevel > 0) {
            this.applySquadShake((Player)mc.f_91074_, this.suppressionLevel, maxLevel);
        }
    }

    public void addSuppressionImpact(int baseImpact, double distance, double velocity) {
        double maxDist = ClientConfigState.maxDetectionRange();
        double distanceFactor = Math.max(0.35, 1.0 - distance / maxDist);
        double velocityFactor = 1.0;
        if (ClientConfigState.enableVelocityScaling()) {
            velocityFactor = Math.min(1.8, 0.9 + velocity * 2.0);
        }
        int impact = (int)((double)baseImpact * distanceFactor * velocityFactor);
        if (ClientConfigState.enableNonlinearAccumulation() && this.recentHitCount >= 2) {
            double multiplier = ClientConfigState.accumulationMultiplier();
            impact = (int)((double)impact * Math.pow(multiplier, Math.min(this.recentHitCount - 1, 4)));
        }
        int flashBoost = 2 + (int)(distanceFactor * 4.0);
        this.accumulateSuppression(impact, true, flashBoost);
    }

    public void addProjectileImpact(double distance, double velocity) {
        double maxDist = ClientConfigState.nearImpactMaxRange();
        if (distance > maxDist) {
            return;
        }
        double distanceFactor = Math.max(0.2, 1.0 - distance / maxDist);
        double speedFactor = 1.0 + Math.min(1.5, velocity * 3.2);
        int baseImpact = ClientConfigState.nearImpactBaseImpact();
        int impact = (int)((double)baseImpact * distanceFactor * speedFactor);
        int flashBoost = 6 + (int)(distanceFactor * 8.0);
        this.accumulateSuppression(impact, true, flashBoost);
    }

    public void addExplosionShock(double distance, float volume) {
        double maxDist = ClientConfigState.explosionMaxRange();
        if (distance > maxDist) {
            return;
        }
        double distanceFactor = Math.max(0.0, 1.0 - distance / maxDist);
        double shaped = Math.pow(distanceFactor, 1.35);
        double volumeFactor = 0.85 + Math.min(1.5, (double)volume) * 0.45;
        int baseImpact = ClientConfigState.explosionBaseImpact();
        int impact = (int)((double)baseImpact * shaped * volumeFactor);
        int flashBoost = 10 + (int)(distanceFactor * 12.0);
        this.accumulateSuppression(impact, false, flashBoost);
    }

    private void applySquadShake(Player p, int level, int maxLevel) {
        float t = Math.min((float)level / (float)maxLevel, 1.0f);
        float baseIntensity = (float)((double)t * ClientConfigState.shakeIntensity());
        float stress = (float)Math.pow(t, 1.2);
        float intensity = baseIntensity * (0.7f + 0.3f * stress);
        float pitch = (this.rnd.nextFloat() - 0.5f) * intensity * 20.0f;
        float yaw = (this.rnd.nextFloat() - 0.5f) * intensity * 20.0f;
        p.m_146926_(p.m_146909_() + pitch);
        p.m_146922_(p.m_146908_() + yaw);
    }

    private void accumulateSuppression(int impact, boolean trackBurst, int flashBoost) {
        if (impact <= 0) {
            return;
        }
        int maxLevel = ClientConfigState.maxSuppressionLevel();
        this.targetLevel = Math.min(maxLevel, this.targetLevel + impact);
        if (trackBurst) {
            ++this.recentHitCount;
            this.hitCounterTicks = 40;
        }
        if (flashBoost > 0) {
            this.shockFlashTicks = Math.min(60, this.shockFlashTicks + flashBoost);
        }
    }

    public int getSuppressionLevel() {
        return this.suppressionLevel;
    }

    public float getSuppressionRatio() {
        int maxLevel = (Integer)Config.MAX_SUPPRESSION_LEVEL.get();
        if (maxLevel <= 0) {
            return 0.0f;
        }
        return Math.min(1.0f, (float)this.suppressionLevel / (float)maxLevel);
    }

    public float getShockFlashIntensity() {
        return Math.min(1.0f, (float)this.shockFlashTicks / 40.0f);
    }
}

