/*
 * Decompiled with CFR 0.152.
 */
package ru.liko.suppressionmod;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.EntityLeaveLevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import ru.liko.suppressionmod.BulletSuppressionHandler;
import ru.liko.suppressionmod.client.ClientConfigState;

@OnlyIn(value=Dist.CLIENT)
public class BulletTracker {
    private static final double NEAR_MISS_THRESHOLD = 3.5;
    private static final double MIN_MOVE_PER_TICK = 0.02;
    private static final double MIN_IMPACT_SPEED = 0.03;
    private static final Set<ResourceLocation> ALLOWED_TYPES = new HashSet<ResourceLocation>();
    private final Map<UUID, Tracked> tracked = new HashMap<UUID, Tracked>();
    private final BulletSuppressionHandler suppression;

    public BulletTracker(BulletSuppressionHandler suppression) {
        this.suppression = suppression;
    }

    @SubscribeEvent
    public void onJoin(EntityJoinLevelEvent e) {
        if (!e.getLevel().m_5776_()) {
            return;
        }
        Entity ent = e.getEntity();
        if (BulletTracker.isTaczBullet(ent.m_6095_())) {
            this.tracked.put(ent.m_20148_(), new Tracked(ent, ent.m_20182_()));
        }
    }

    @SubscribeEvent
    public void onLeave(EntityLeaveLevelEvent e) {
        double maxRange;
        Projectile proj;
        Entity owner;
        if (!e.getLevel().m_5776_()) {
            return;
        }
        Entity entity = e.getEntity();
        Tracked t = this.tracked.remove(entity.m_20148_());
        if (t == null || !BulletTracker.isTaczBullet(entity.m_6095_())) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (mc == null || mc.f_91074_ == null || mc.f_91073_ == null) {
            return;
        }
        if (entity instanceof Projectile && (owner = (proj = (Projectile)entity).m_19749_()) != null && owner.m_20148_().equals(mc.f_91074_.m_20148_())) {
            return;
        }
        Vec3 eye = mc.f_91074_.m_20299_(1.0f);
        Vec3 impactPos = entity.m_20182_();
        if (impactPos == null) {
            impactPos = t.prev;
        } else if (t.prev != null) {
            impactPos = impactPos.m_82549_(t.prev).m_82490_(0.5);
        }
        if (impactPos == null) {
            return;
        }
        double distance = impactPos.m_82554_(eye);
        if (distance > (maxRange = ClientConfigState.nearImpactMaxRange())) {
            return;
        }
        double speed = Math.max(t.lastSpeed, entity.m_20184_().m_82553_());
        if (speed < 0.03) {
            return;
        }
        this.suppression.addProjectileImpact(distance, speed);
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent e) {
        if (e.phase != TickEvent.Phase.END) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (mc == null || mc.m_91104_() || mc.f_91074_ == null || mc.f_91073_ == null) {
            return;
        }
        LocalPlayer pl = mc.f_91074_;
        UUID local = pl.m_20148_();
        Vec3 eye = pl.m_20299_(1.0f);
        double maxRange = ClientConfigState.maxDetectionRange();
        Iterator<Map.Entry<UUID, Tracked>> it = this.tracked.entrySet().iterator();
        while (it.hasNext()) {
            Projectile proj;
            Entity owner;
            Map.Entry<UUID, Tracked> en = it.next();
            Tracked t = en.getValue();
            Entity ent = t.entity;
            if (ent == null || ent.m_213877_() || ent.m_9236_() != mc.f_91073_) {
                it.remove();
                continue;
            }
            ++t.age;
            if (ent instanceof Projectile && (owner = (proj = (Projectile)ent).m_19749_()) != null && owner.m_20148_().equals(local)) {
                t.prev = ent.m_20182_();
                continue;
            }
            Vec3 curr = ent.m_20182_();
            Vec3 prev = t.prev;
            double velocity = curr.m_82554_(prev);
            double camDist = curr.m_82554_(eye);
            t.lastSpeed = velocity;
            if (camDist > maxRange || velocity < 0.02) {
                t.prev = curr;
                continue;
            }
            double d = BulletTracker.segmentPointDistance(prev, curr, eye);
            if (t.cooldown <= 0 && d <= 3.5) {
                int baseImpact = ClientConfigState.singleBulletImpact();
                this.suppression.addSuppressionImpact(baseImpact, d, velocity);
                t.cooldown = 4;
            }
            if (t.cooldown > 0) {
                --t.cooldown;
            }
            t.prev = curr;
        }
    }

    private static boolean isTaczBullet(EntityType<?> type) {
        ResourceLocation rl = EntityType.m_20613_(type);
        if (rl == null) {
            return false;
        }
        if (!ALLOWED_TYPES.isEmpty()) {
            return ALLOWED_TYPES.contains(rl);
        }
        String ns = rl.m_135827_();
        String path = rl.m_135815_();
        return "tacz".equals(ns) || path.contains("bullet") || path.contains("ammo") || path.contains("projectile");
    }

    private static double segmentPointDistance(Vec3 a, Vec3 b, Vec3 p) {
        Vec3 ab = b.m_82546_(a);
        double ab2 = ab.m_82556_();
        if (ab2 < 1.0E-8) {
            return p.m_82554_(a);
        }
        double t = p.m_82546_(a).m_82526_(ab) / ab2;
        t = Math.max(0.0, Math.min(1.0, t));
        Vec3 c = a.m_82549_(ab.m_82490_(t));
        return p.m_82554_(c);
    }

    private static class Tracked {
        final UUID uuid;
        final Entity entity;
        Vec3 prev;
        int cooldown = 0;
        int age = 0;
        double lastSpeed = 0.0;

        Tracked(Entity e, Vec3 p) {
            this.uuid = e.m_20148_();
            this.entity = e;
            this.prev = p;
            this.lastSpeed = e.m_20184_().m_82553_();
        }
    }
}

