/*
 * Decompiled with CFR 0.152.
 */
package ru.liko.suppressionmod;

import net.minecraftforge.common.ForgeConfigSpec;

public class Config {
    public static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    public static final ForgeConfigSpec SPEC;
    public static final ForgeConfigSpec.DoubleValue MAX_DETECTION_RANGE;
    public static final ForgeConfigSpec.IntValue MAX_SUPPRESSION_LEVEL;
    public static final ForgeConfigSpec.IntValue SINGLE_BULLET_IMPACT;
    public static final ForgeConfigSpec.DoubleValue ACCUMULATION_MULTIPLIER;
    public static final ForgeConfigSpec.IntValue RECOVERY_RATE;
    public static final ForgeConfigSpec.IntValue TARGET_DECAY_RATE;
    public static final ForgeConfigSpec.DoubleValue SHAKE_INTENSITY;
    public static final ForgeConfigSpec.DoubleValue VIGNETTE_MAX_ALPHA;
    public static final ForgeConfigSpec.BooleanValue ENABLE_VELOCITY_SCALING;
    public static final ForgeConfigSpec.BooleanValue ENABLE_NONLINEAR_ACCUMULATION;
    public static final ForgeConfigSpec.IntValue EXPLOSION_BASE_IMPACT;
    public static final ForgeConfigSpec.DoubleValue EXPLOSION_MAX_RANGE;
    public static final ForgeConfigSpec.IntValue NEAR_IMPACT_BASE_IMPACT;
    public static final ForgeConfigSpec.DoubleValue NEAR_IMPACT_MAX_RANGE;
    public static final ForgeConfigSpec.DoubleValue UI_TINT_STRENGTH;
    public static final ForgeConfigSpec.DoubleValue UI_VIGNETTE_STRENGTH;
    public static final ForgeConfigSpec.DoubleValue UI_FLASH_STRENGTH;
    public static final ForgeConfigSpec.DoubleValue UI_FADE_IN_SPEED;
    public static final ForgeConfigSpec.DoubleValue UI_FADE_OUT_SPEED;

    static {
        BUILDER.comment("Core suppression tuning").push("detection");
        MAX_DETECTION_RANGE = BUILDER.comment("Maximum distance (in blocks) to register nearby projectiles").defineInRange("maxDetectionRange", 16.0, 4.0, 64.0);
        BUILDER.pop();
        BUILDER.push("intensity");
        MAX_SUPPRESSION_LEVEL = BUILDER.comment("Upper bound for accumulated suppression before clamping").defineInRange("maxSuppressionLevel", 100, 20, 300);
        SINGLE_BULLET_IMPACT = BUILDER.comment("Suppression applied when a hostile bullet passes near the player").defineInRange("singleBulletImpact", 18, 5, 50);
        ACCUMULATION_MULTIPLIER = BUILDER.comment("Multiplier applied when several hits occur in quick succession").defineInRange("accumulationMultiplier", 1.35, 1.0, 2.5);
        BUILDER.pop();
        BUILDER.push("recovery");
        RECOVERY_RATE = BUILDER.comment("Suppression removed every client tick while recovering").defineInRange("recoveryRate", 1, 1, 5);
        TARGET_DECAY_RATE = BUILDER.comment("How fast the suppression target value falls when not under fire").defineInRange("targetDecayRate", 2, 1, 10);
        BUILDER.pop();
        BUILDER.push("visual");
        SHAKE_INTENSITY = BUILDER.comment("Camera shake intensity factor (0 disables shake entirely)").defineInRange("shakeIntensity", 0.22, 0.0, 1.0);
        VIGNETTE_MAX_ALPHA = BUILDER.comment("Maximum alpha the vignette overlay is allowed to reach").defineInRange("vignetteMaxAlpha", 0.65, 0.0, 1.0);
        BUILDER.pop();
        BUILDER.push("advanced");
        ENABLE_VELOCITY_SCALING = BUILDER.comment("Scale suppression contribution based on projectile speed").define("enableVelocityScaling", true);
        ENABLE_NONLINEAR_ACCUMULATION = BUILDER.comment("Increase suppression exponentially when multiple rounds land nearby").define("enableNonlinearAccumulation", true);
        BUILDER.pop();
        BUILDER.push("explosions");
        EXPLOSION_BASE_IMPACT = BUILDER.comment("Base suppression generated by an explosion inside the detection radius").defineInRange("explosionBaseImpact", 38, 5, 200);
        EXPLOSION_MAX_RANGE = BUILDER.comment("Maximum radius (blocks) where an explosion can suppress the player").defineInRange("explosionMaxRange", 14.0, 4.0, 48.0);
        BUILDER.pop();
        BUILDER.push("impacts");
        NEAR_IMPACT_BASE_IMPACT = BUILDER.comment("Suppression produced when a projectile impacts near the player").defineInRange("nearImpactBaseImpact", 24, 5, 150);
        NEAR_IMPACT_MAX_RANGE = BUILDER.comment("Maximum distance (blocks) to consider impact suppression").defineInRange("nearImpactMaxRange", 8.0, 2.0, 24.0);
        BUILDER.pop();
        BUILDER.push("clientVisuals");
        UI_TINT_STRENGTH = BUILDER.comment("Scalar applied to the screen-wide tint when suppressed").defineInRange("uiTintStrength", 0.55, 0.0, 1.5);
        UI_VIGNETTE_STRENGTH = BUILDER.comment("Scalar applied to the vignette texture opacity").defineInRange("uiVignetteStrength", 0.65, 0.0, 1.5);
        UI_FLASH_STRENGTH = BUILDER.comment("Scalar applied to the short lived flash component").defineInRange("uiFlashStrength", 0.6, 0.0, 1.5);
        UI_FADE_IN_SPEED = BUILDER.comment("Interpolation factor used while the overlay is appearing (0-1)").defineInRange("uiFadeInSpeed", 0.16, 0.01, 1.0);
        UI_FADE_OUT_SPEED = BUILDER.comment("Interpolation factor used while the overlay is fading out (0-1)").defineInRange("uiFadeOutSpeed", 0.08, 0.01, 1.0);
        BUILDER.pop();
        SPEC = BUILDER.build();
    }
}

