/*
 * Decompiled with CFR 0.152.
 */
package ru.liko.suppressionmod;

import java.util.HashSet;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.sound.PlaySoundEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import ru.liko.suppressionmod.BulletSuppressionHandler;
import ru.liko.suppressionmod.client.ClientConfigState;

@OnlyIn(value=Dist.CLIENT)
public class EnvironmentalSuppressionTracker {
    private static final Set<ResourceLocation> EXPLOSION_SOUNDS = new HashSet<ResourceLocation>();
    private final BulletSuppressionHandler suppression;

    public EnvironmentalSuppressionTracker(BulletSuppressionHandler suppression) {
        this.suppression = suppression;
    }

    @SubscribeEvent
    public void onPlaySound(PlaySoundEvent event) {
        double maxRange;
        double sz;
        double sy;
        SoundInstance sound = event.getSound();
        if (sound == null) {
            return;
        }
        ResourceLocation id = sound.m_7904_();
        if (!EnvironmentalSuppressionTracker.isExplosionSound(id)) {
            return;
        }
        if (sound.m_7796_()) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (mc == null || player == null || mc.f_91073_ == null) {
            return;
        }
        double sx = sound.m_7772_();
        double distance = Math.sqrt(player.m_20275_(sx, sy = sound.m_7780_(), sz = sound.m_7778_()));
        if (distance > (maxRange = ClientConfigState.explosionMaxRange())) {
            return;
        }
        float volume = sound.m_7769_();
        this.suppression.addExplosionShock(distance, volume);
    }

    private static boolean isExplosionSound(ResourceLocation id) {
        if (id == null) {
            return false;
        }
        if (EXPLOSION_SOUNDS.contains(id)) {
            return true;
        }
        String path = id.m_135815_();
        return path.contains("explode") || path.contains("explosion");
    }

    static {
        EXPLOSION_SOUNDS.add(new ResourceLocation("minecraft", "entity.generic.explode"));
        EXPLOSION_SOUNDS.add(new ResourceLocation("minecraft", "entity.creeper.explode"));
        EXPLOSION_SOUNDS.add(new ResourceLocation("minecraft", "entity.dragon_fireball.explode"));
        EXPLOSION_SOUNDS.add(new ResourceLocation("minecraft", "entity.firework_rocket.large_blast"));
    }
}

