/*
 * Decompiled with CFR 0.152.
 */
package ru.liko.suppressionmod;

import com.tacz.guns.api.event.server.AmmoHitBlockEvent;
import com.tacz.guns.entity.EntityKineticBullet;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.level.ExplosionEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import ru.liko.suppressionmod.Config;
import ru.liko.suppressionmod.network.NetworkHandler;
import ru.liko.suppressionmod.network.SuppressionImpactPacket;
import ru.liko.suppressionmod.network.SuppressionSettingsPacket;

@Mod.EventBusSubscriber(modid="suppressionmod", bus=Mod.EventBusSubscriber.Bus.FORGE)
public final class ServerSuppressionListener {
    private ServerSuppressionListener() {
    }

    @SubscribeEvent
    public static void onAmmoHitBlock(AmmoHitBlockEvent event) {
        Level level = event.getLevel();
        if (level.m_5776_()) {
            return;
        }
        EntityKineticBullet ammo = event.getAmmo();
        if (ammo == null) {
            return;
        }
        BlockHitResult hit = event.getHitResult();
        Vec3 hitPos = hit.m_82450_();
        double maxRange = (Double)Config.NEAR_IMPACT_MAX_RANGE.get();
        float speed = (float)ammo.m_20184_().m_82553_();
        Entity owner = ammo.m_19749_();
        for (Player player : level.m_6907_()) {
            double distance;
            if (!(player instanceof ServerPlayer)) continue;
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (player.m_5833_() || owner != null && player.m_20148_().equals(owner.m_20148_()) || (distance = Math.sqrt(player.m_20238_(hitPos))) > maxRange) continue;
            NetworkHandler.sendTo(serverPlayer, SuppressionImpactPacket.impact(hitPos.f_82479_, hitPos.f_82480_, hitPos.f_82481_, speed));
        }
    }

    @SubscribeEvent
    public static void onExplosion(ExplosionEvent.Detonate event) {
        Level level = event.getLevel();
        if (level.m_5776_()) {
            return;
        }
        Explosion explosion = event.getExplosion();
        Vec3 pos = explosion.getPosition();
        double maxRange = (Double)Config.EXPLOSION_MAX_RANGE.get();
        int affectedBlocks = explosion.m_46081_().size();
        float power = 1.0f + Math.min(3.5f, (float)affectedBlocks / 30.0f);
        for (Player player : level.m_6907_()) {
            double distance;
            if (!(player instanceof ServerPlayer)) continue;
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (player.m_5833_() || (distance = Math.sqrt(player.m_20238_(pos))) > maxRange) continue;
            NetworkHandler.sendTo(serverPlayer, SuppressionImpactPacket.explosion(pos.f_82479_, pos.f_82480_, pos.f_82481_, power));
        }
    }

    @SubscribeEvent
    public static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        NetworkHandler.sendTo(serverPlayer, ServerSuppressionListener.buildSettingsPacket());
    }

    @SubscribeEvent
    public static void onConfigReload(ModConfigEvent.Reloading event) {
        if (event.getConfig().getSpec() != Config.SPEC) {
            return;
        }
        NetworkHandler.sendToAll(ServerSuppressionListener.buildSettingsPacket());
    }

    private static SuppressionSettingsPacket buildSettingsPacket() {
        return new SuppressionSettingsPacket((Double)Config.MAX_DETECTION_RANGE.get(), (Integer)Config.MAX_SUPPRESSION_LEVEL.get(), (Integer)Config.SINGLE_BULLET_IMPACT.get(), (Double)Config.ACCUMULATION_MULTIPLIER.get(), (Integer)Config.RECOVERY_RATE.get(), (Integer)Config.TARGET_DECAY_RATE.get(), (Double)Config.SHAKE_INTENSITY.get(), (Double)Config.VIGNETTE_MAX_ALPHA.get(), (Boolean)Config.ENABLE_VELOCITY_SCALING.get(), (Boolean)Config.ENABLE_NONLINEAR_ACCUMULATION.get(), (Integer)Config.EXPLOSION_BASE_IMPACT.get(), (Double)Config.EXPLOSION_MAX_RANGE.get(), (Integer)Config.NEAR_IMPACT_BASE_IMPACT.get(), (Double)Config.NEAR_IMPACT_MAX_RANGE.get(), (Double)Config.UI_TINT_STRENGTH.get(), (Double)Config.UI_VIGNETTE_STRENGTH.get(), (Double)Config.UI_FLASH_STRENGTH.get(), (Double)Config.UI_FADE_IN_SPEED.get(), (Double)Config.UI_FADE_OUT_SPEED.get());
    }
}

