/*
 * Decompiled with CFR 0.152.
 */
package ru.liko.suppressionmod;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import ru.liko.suppressionmod.BulletSuppressionHandler;
import ru.liko.suppressionmod.client.ClientConfigState;

@Mod.EventBusSubscriber(modid="suppressionmod", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE)
public class SuppressionOverlay {
    private static final ResourceLocation OVERLAY_TEXTURE = new ResourceLocation("suppressionmod", "textures/gui/suppression_vignette.png");
    private static BulletSuppressionHandler handler;
    private static float smoothedOverlayAlpha;
    private static float smoothedTintAlpha;

    public static void setHandler(BulletSuppressionHandler h) {
        handler = h;
        smoothedOverlayAlpha = 0.0f;
        smoothedTintAlpha = 0.0f;
    }

    @SubscribeEvent
    public static void onOverlay(RenderGuiOverlayEvent.Post event) {
        if (handler == null) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (mc == null || mc.m_91268_() == null) {
            return;
        }
        float suppression = handler.getSuppressionRatio();
        float flash = handler.getShockFlashIntensity();
        float maxAlpha = (float)ClientConfigState.vignetteMaxAlpha();
        float tintScale = (float)ClientConfigState.uiTintStrength();
        float vignetteScale = (float)ClientConfigState.uiVignetteStrength();
        float flashScale = (float)ClientConfigState.uiFlashStrength();
        float fadeIn = Mth.m_14036_((float)((float)ClientConfigState.uiFadeInSpeed()), (float)0.01f, (float)1.0f);
        float fadeOut = Mth.m_14036_((float)((float)ClientConfigState.uiFadeOutSpeed()), (float)0.01f, (float)1.0f);
        float baseTarget = Math.min(1.0f, suppression * maxAlpha * 0.7f) * vignetteScale;
        float flashTarget = Math.min(1.0f, flash * 0.65f) * flashScale;
        float overlayTarget = Math.min(1.0f, baseTarget * 0.5f + flashTarget * 0.8f);
        float tintTarget = Math.min(1.0f, (baseTarget * 0.3f + flashTarget * 0.2f) * tintScale);
        float overlayLerp = overlayTarget > smoothedOverlayAlpha ? fadeIn : fadeOut;
        float tintLerp = tintTarget > smoothedTintAlpha ? fadeIn : fadeOut;
        smoothedOverlayAlpha = Mth.m_14179_((float)overlayLerp, (float)smoothedOverlayAlpha, (float)overlayTarget);
        smoothedTintAlpha = Mth.m_14179_((float)tintLerp, (float)smoothedTintAlpha, (float)tintTarget);
        if (smoothedOverlayAlpha <= 0.01f && smoothedTintAlpha <= 0.01f) {
            return;
        }
        GuiGraphics graphics = event.getGuiGraphics();
        int width = mc.m_91268_().m_85445_();
        int height = mc.m_91268_().m_85446_();
        if (smoothedTintAlpha > 0.01f) {
            int tint = FastColor.ARGB32.m_13660_((int)((int)(smoothedTintAlpha * 90.0f)), (int)32, (int)28, (int)26);
            graphics.m_280509_(0, 0, width, height, tint);
        }
        if (smoothedOverlayAlpha > 0.01f) {
            RenderSystem.enableBlend();
            graphics.m_280246_(1.0f, 1.0f, 1.0f, Math.min(1.0f, smoothedOverlayAlpha));
            graphics.m_280411_(OVERLAY_TEXTURE, 0, 0, width, height, 0.0f, 0.0f, 256, 256, 256, 256);
            graphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
            RenderSystem.disableBlend();
        }
    }

    static {
        smoothedOverlayAlpha = 0.0f;
        smoothedTintAlpha = 0.0f;
    }
}

