/*
 * Decompiled with CFR 0.152.
 */
package ru.liko.suppressionmod.network;

import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;
import ru.liko.suppressionmod.network.SuppressionImpactPacket;
import ru.liko.suppressionmod.network.SuppressionSettingsPacket;

public final class NetworkHandler {
    public static final String PROTOCOL_VERSION = "1";
    private static final SimpleChannel CHANNEL = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("suppressionmod", "main"), () -> "1", "1"::equals, "1"::equals);
    private static boolean initialized = false;
    private static int packetId = 0;

    private NetworkHandler() {
    }

    public static void init() {
        if (initialized) {
            return;
        }
        CHANNEL.registerMessage(packetId++, SuppressionImpactPacket.class, SuppressionImpactPacket::encode, SuppressionImpactPacket::decode, SuppressionImpactPacket::handle);
        CHANNEL.registerMessage(packetId++, SuppressionSettingsPacket.class, SuppressionSettingsPacket::encode, SuppressionSettingsPacket::decode, SuppressionSettingsPacket::handle);
        initialized = true;
    }

    public static <MSG> void sendTo(ServerPlayer player, MSG message) {
        CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), message);
    }

    public static <MSG> void sendToAll(MSG message) {
        CHANNEL.send(PacketDistributor.ALL.noArg(), message);
    }
}

