/*
 * Decompiled with CFR 0.152.
 */
package com.corrinedev.gundurability;

import com.corrinedev.gundurability.config.Config;
import com.corrinedev.gundurability.events.TaczEvents;
import com.corrinedev.gundurability.init.GundurabilityModBlocks;
import com.corrinedev.gundurability.init.GundurabilityModItems;
import com.corrinedev.gundurability.init.GundurabilityModMenus;
import com.corrinedev.gundurability.init.GundurabilityModSounds;
import com.corrinedev.gundurability.init.GundurabilityModTabs;
import com.corrinedev.gundurability.util.Work;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.util.thread.SidedThreadGroups;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;
import org.slf4j.Logger;

@Mod(value="gundurability")
public class Gundurability {
    public static final String MODID = "gundurability";
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final String PROTOCOL_VERSION = "1";
    public static final SimpleChannel PACKET_HANDLER = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("gundurability", "gundurability"), () -> "1", "1"::equals, "1"::equals);
    private static int messageID = 0;
    private static final Collection<Work> workQueue = new ConcurrentLinkedQueue<Work>();

    public Gundurability() {
        Config.SPEC.register();
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        bus.addListener(GundurabilityModItems::register);
        GundurabilityModSounds.REGISTRY.register(bus);
        GundurabilityModBlocks.REGISTRY.register(bus);
        GundurabilityModItems.REPAIRTABLEREGISTER.register(bus);
        GundurabilityModTabs.REGISTRY.register(bus);
        GundurabilityModMenus.REGISTRY.register(bus);
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register(TaczEvents.class);
    }

    public static <T> void addNetworkMessage(Class<T> messageType, BiConsumer<T, FriendlyByteBuf> encoder, Function<FriendlyByteBuf, T> decoder, BiConsumer<T, Supplier<NetworkEvent.Context>> messageConsumer) {
        PACKET_HANDLER.registerMessage(messageID, messageType, encoder, decoder, messageConsumer);
        ++messageID;
    }

    public static void queueServerWork(Work work) {
        if (Thread.currentThread().getThreadGroup() == SidedThreadGroups.SERVER) {
            workQueue.add(work);
        }
    }

    public static <MSG> void sendToPlayer(MSG msg, ServerPlayer player) {
        PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> player), msg);
    }

    @SubscribeEvent
    public void tick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            ArrayList actions = new ArrayList();
            workQueue.forEach(work -> {
                --work.tick;
                work.tick();
                if (work.tick == 0) {
                    actions.add(work);
                }
            });
            actions.forEach(Runnable::run);
            workQueue.removeAll(actions);
        }
    }
}

