/*
 * Decompiled with CFR 0.152.
 */
package com.corrinedev.gundurability.events;

import com.corrinedev.gundurability.Gundurability;
import com.corrinedev.gundurability.config.BiomeModifier;
import com.corrinedev.gundurability.config.Config;
import com.corrinedev.gundurability.config.DurabilityModifier;
import com.corrinedev.gundurability.init.GundurabilityModGameRules;
import com.corrinedev.gundurability.init.GundurabilityModSounds;
import com.corrinedev.gundurability.util.Work;
import com.tacz.guns.api.event.common.GunFireEvent;
import com.tacz.guns.item.ModernKineticGunItem;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class TaczEvents {
    public static final String JAM = "Jammed";
    public static final String DURABILITY = "Durability";
    public static final String OTHERHANDLE = "gundurability$handlingJamming";

    @SubscribeEvent
    public static void onShootEvent(GunFireEvent event) {
        if (event.getLogicalSide().isServer()) {
            if (!(event.getShooter() instanceof Player) && event.getGunItemStack().m_41784_().m_128471_(JAM)) {
                TaczEvents.handleUnjammingForNonPlayers(event.getShooter());
            }
            if (event.getShooter().m_21205_().m_41784_().m_128441_(DURABILITY)) {
                if (!event.getGunItemStack().m_41784_().m_128471_(JAM) && event.getGunItemStack().m_41784_().m_128451_(DURABILITY) > 0) {
                    float biomeModifier = 1.0f;
                    float gunModifier = 1.0f;
                    double randomNumber = Math.random();
                    for (Record modifier : (List)Config.DURABILITY_LIST.get()) {
                        if (!event.getGunItemStack().m_41784_().m_128461_("GunId").equals(((DurabilityModifier)modifier).gunId())) continue;
                        if (randomNumber < 0.5) {
                            gunModifier = (int)Math.floor(((DurabilityModifier)modifier).jamMultiplier());
                            continue;
                        }
                        gunModifier = (int)Math.ceil(((DurabilityModifier)modifier).jamMultiplier());
                    }
                    for (Record modifier : (List)Config.BIOMEMODIFIERS.get()) {
                        if (!event.getShooter().m_9236_().m_204166_(event.getShooter().m_20183_()).m_203373_(new ResourceLocation(((BiomeModifier)modifier).biomeName()))) continue;
                        if (randomNumber < 0.5) {
                            biomeModifier = (int)Math.floor(((BiomeModifier)modifier).multiplier());
                            continue;
                        }
                        biomeModifier = (int)Math.ceil(((BiomeModifier)modifier).multiplier());
                    }
                    if (event.getShooter().m_21205_().m_41784_().m_128461_("GunFireMode").equals("BURST")) {
                        event.getShooter().m_21205_().m_41784_().m_128405_(DURABILITY, event.getShooter().m_21205_().m_41784_().m_128451_(DURABILITY) - Math.round(3.0f * (gunModifier * biomeModifier)));
                    } else {
                        event.getShooter().m_21205_().m_41784_().m_128405_(DURABILITY, event.getShooter().m_21205_().m_41784_().m_128451_(DURABILITY) - Math.round(1.0f * (gunModifier * biomeModifier)));
                    }
                }
                if (!event.getShooter().m_21205_().m_41784_().m_128471_(JAM) && event.getGunItemStack().m_41784_().m_128451_(DURABILITY) != 0) {
                    boolean allowjam = true;
                    for (int i = 0; i < ((List)Config.GUN_LIST.get()).size(); ++i) {
                        if (!event.getGunItemStack().m_41784_().m_128461_("GunId").equals(((String)((List)Config.GUN_LIST.get()).get(i)).toString())) continue;
                        allowjam = false;
                    }
                    if ((Integer)Config.JAMCHANCE.get() != 0 && allowjam && Mth.m_216271_((RandomSource)RandomSource.m_216327_(), (int)-1, (int)Math.round((float)event.getShooter().m_21205_().m_41784_().m_128451_(DURABILITY) / (float)((Integer)Config.JAMCHANCE.get()).intValue())) == 0) {
                        event.getShooter().m_21205_().m_41784_().m_128379_(JAM, true);
                        event.getShooter().m_216990_((SoundEvent)GundurabilityModSounds.JAMSFX.get());
                        LivingEntity livingEntity = event.getShooter();
                        if (livingEntity instanceof Player) {
                            Player player = (Player)livingEntity;
                            player.m_5661_((Component)MutableComponent.m_237204_((ComponentContents)Component.m_237113_((String)"Jammed!").m_214077_()).m_130940_(ChatFormatting.ITALIC).m_130940_(ChatFormatting.RED), true);
                        }
                    }
                } else {
                    if ((event.getShooter().m_9236_().m_46469_().m_46207_(GundurabilityModGameRules.GUNBREAK) || ((Boolean)Config.GUNSBREAK.get()).booleanValue()) && event.getGunItemStack().m_41784_().m_128451_(DURABILITY) <= 0) {
                        event.getShooter().m_21205_().m_41764_(0);
                        event.getShooter().m_216990_(SoundEvents.f_12018_);
                        LivingEntity livingEntity = event.getShooter();
                        if (livingEntity instanceof Player) {
                            Player player = (Player)livingEntity;
                            player.m_5661_((Component)MutableComponent.m_237204_((ComponentContents)Component.m_237113_((String)"Your Gun Broke").m_214077_()).m_130940_(ChatFormatting.BOLD).m_130940_(ChatFormatting.RED), true);
                        }
                    }
                    event.setCanceled(true);
                }
            } else {
                event.getShooter().m_21205_().m_41784_().m_128405_(DURABILITY, Config.getDurability(event.getShooter().m_21205_().m_41784_().m_128461_("GunId")));
            }
        }
        if (event.getLogicalSide().isClient() && (event.getGunItemStack().m_41784_().m_128471_(JAM) || event.getGunItemStack().m_41784_().m_128451_(DURABILITY) <= 0)) {
            event.setCanceled(true);
        }
    }

    public static void handleUnjammingForNonPlayers(LivingEntity livingEntity) {
        if (livingEntity.getPersistentData().m_128441_(OTHERHANDLE) && livingEntity.getPersistentData().m_128471_(OTHERHANDLE)) {
            return;
        }
        int jamTime = 100;
        livingEntity.getPersistentData().m_128379_(OTHERHANDLE, true);
        if (livingEntity.m_21205_().m_41720_() instanceof ModernKineticGunItem) {
            for (DurabilityModifier modifier : (List)Config.DURABILITY_LIST.get()) {
                if (!livingEntity.m_21205_().m_41784_().m_128461_("GunId").equals(modifier.gunId())) continue;
                jamTime = modifier.jamTime();
            }
        }
        if (livingEntity.m_21205_().m_41784_().m_128471_(JAM)) {
            Gundurability.queueServerWork(new Work<LivingEntity>(livingEntity, jamTime){
                public boolean cancel = false;

                @Override
                public void tick() {
                    if (!(((LivingEntity)this.entity).m_21205_().m_41720_() instanceof ModernKineticGunItem)) {
                        this.cancel = true;
                    }
                }

                @Override
                public void run() {
                    if (((LivingEntity)this.entity).m_21205_().m_41720_() instanceof ModernKineticGunItem && !this.cancel) {
                        ((LivingEntity)this.entity).m_21205_().m_41784_().m_128379_(TaczEvents.JAM, false);
                        ((LivingEntity)this.entity).getPersistentData().m_128379_(TaczEvents.OTHERHANDLE, false);
                    }
                }
            });
        }
    }
}

