/*
 * Decompiled with CFR 0.152.
 */
package com.corrinedev.gundurability.network;

import com.corrinedev.gundurability.Gundurability;
import com.corrinedev.gundurability.config.Config;
import com.corrinedev.gundurability.item.RepairItem;
import com.corrinedev.gundurability.world.inventory.RepairGUIMenu;
import com.tacz.guns.item.ModernKineticGunItem;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class RepairGUIButtonMessage {
    private final int buttonID;
    private final int x;
    private final int y;
    private final int z;

    public RepairGUIButtonMessage(FriendlyByteBuf buffer) {
        this.buttonID = buffer.readInt();
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
    }

    public RepairGUIButtonMessage(int buttonID, int x, int y, int z) {
        this.buttonID = buttonID;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static void buffer(RepairGUIButtonMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }

    public static void handler(RepairGUIButtonMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer entity = context.getSender();
            int buttonID = message.buttonID;
            int x = message.x;
            int y = message.y;
            int z = message.z;
            RepairGUIButtonMessage.handleButtonAction((Player)entity, buttonID, x, y, z);
        });
        context.setPacketHandled(true);
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.m_9236_();
        if (!world.m_46805_(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            RepairGUIButtonMessage.execute(entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        Gundurability.addNetworkMessage(RepairGUIButtonMessage.class, RepairGUIButtonMessage::buffer, RepairGUIButtonMessage::new, RepairGUIButtonMessage::handler);
    }

    public static void execute(Player entity) {
        AbstractContainerMenu abstractContainerMenu;
        if (entity instanceof ServerPlayer && (abstractContainerMenu = entity.f_36096_) instanceof RepairGUIMenu) {
            RepairGUIMenu containerMenu = (RepairGUIMenu)abstractContainerMenu;
            int durability = (Integer)Config.MAXDURABILITY.get();
            if (containerMenu.m_38853_(0).m_7993_().m_41720_() instanceof ModernKineticGunItem) {
                durability = Config.getDurability(containerMenu.m_38853_(0).m_7993_().m_41784_().m_128461_("GunId"));
            }
            double percent = (double)durability / 100.0;
            Slot gunSlot = containerMenu.customSlots.get(0);
            int repairAmount = 0;
            if (!gunSlot.m_7993_().m_41784_().m_128441_("Durability")) {
                return;
            }
            for (Slot slot : containerMenu.customSlots.values()) {
                RepairItem repairItem;
                Item item = slot.m_7993_().m_41720_();
                if (!(item instanceof RepairItem) || !(repairItem = (RepairItem)item).isBetween(gunSlot.m_7993_()) || repairItem.getGunIds() != null && !repairItem.getGunIds().contains(gunSlot.m_7993_().m_41784_().m_128461_("GunId"))) continue;
                repairAmount += repairItem.getRepairAmount(gunSlot.m_7993_());
                slot.m_7993_().m_41721_(slot.m_7993_().m_41773_() + 1);
                if (slot.m_7993_().m_41773_() < slot.m_7993_().m_41776_()) continue;
                slot.m_7993_().m_41764_(0);
            }
            repairAmount = Mth.m_14045_((int)(repairAmount + gunSlot.m_7993_().m_41784_().m_128451_("Durability")), (int)0, (int)Config.getDurability(gunSlot.m_7993_().m_41784_().m_128461_("GunId")));
            gunSlot.m_7993_().m_41784_().m_128405_("Durability", repairAmount);
        }
    }
}

