/*
 * Decompiled with CFR 0.152.
 */
package com.favouriteless.toughastweaks;

import com.favouriteless.toughastweaks.Config;
import com.favouriteless.toughastweaks.api.ICompatHandler;
import com.favouriteless.toughastweaks.common.compat_handlers.CompatHandlerRegistry;
import com.favouriteless.toughastweaks.common.compat_handlers.CreateHandler;
import com.favouriteless.toughastweaks.common.compat_handlers.FarmersDelightHandler;
import com.favouriteless.toughastweaks.common.compat_handlers.MinecraftHandler;
import com.mojang.logging.LogUtils;
import java.util.function.Supplier;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.slf4j.Logger;

@Mod(value="toughastweaked")
public class ToughAsTweaked {
    public static final String MOD_ID = "toughastweaked";
    public static final Logger LOGGER = LogUtils.getLogger();
    private static final CompatHandlerRegistry compatHandlerReg = new CompatHandlerRegistry();

    public ToughAsTweaked() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.SPEC, "toughastweaked-common.toml");
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onLoadComplete);
    }

    public void onLoadComplete(FMLLoadCompleteEvent event) {
        event.enqueueWork(() -> {
            if (((Boolean)Config.Minecraft.ENABLE.get()).booleanValue()) {
                ToughAsTweaked.registerCompatHandler("minecraft", MinecraftHandler::new);
            }
            if (((Boolean)Config.Create.ENABLE.get()).booleanValue()) {
                ToughAsTweaked.registerCompatHandler("create", CreateHandler::new);
            }
            if (((Boolean)Config.FarmersDelight.ENABLE.get()).booleanValue()) {
                ToughAsTweaked.registerCompatHandler("farmersdelight", FarmersDelightHandler::new);
            }
            for (ICompatHandler handler : compatHandlerReg.getRelevantHandlers()) {
                handler.init();
            }
        });
    }

    public static void registerCompatHandler(String modId, Supplier<ICompatHandler> handler) {
        compatHandlerReg.register(modId, handler);
    }
}

